/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2006-02-21
 * Description : a generic list view item widget to 
 *               display metadata
 * 
 * Copyright (C) 2006-2008 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */

// TQt includes.

#include <tqpalette.h>
#include <tqfont.h>
#include <tqpainter.h>

// Local includes.

#include "metadatalistviewitem.h"

namespace Digikam
{

MetadataListViewItem::MetadataListViewItem(TQListViewItem *parent, const TQString& key,
                                           const TQString& title, const TQString& value)
                    : TQListViewItem(parent)
{
    m_key = key;
    
    setSelectable(true);
    setText(0, title);
 
    TQString tagVal = value.simplifyWhiteSpace();   
    if (tagVal.length() > 128)
    {
        tagVal.truncate(128);
        tagVal.append("...");
    }
    setText(1, tagVal);
}

MetadataListViewItem::~MetadataListViewItem()
{
} 

TQString MetadataListViewItem::getKey()
{
    return m_key;
}

TQString MetadataListViewItem::getTitle()
{
    return text(0);
}

TQString MetadataListViewItem::getValue()
{
    return text(1);
}

}  // namespace Digikam
