/***************************************************************************
 *   Copyright (C) 2006-2012 by Thomas Schweitzer                          *
 *   thomas-schweitzer(at)arcor.de                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2.0 as   *
 *   published by the Free Software Foundation.                            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program in the file LICENSE.GPL; if not, write to the *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef UIGUIHIGHLIGHTER_H
#define UIGUIHIGHLIGHTER_H

#include <tqcolor.h>
#include <tqfont.h>
#include <tqobject.h>
#include <tqmap.h>
#include <tqstringlist.h>

class TQAction;
class TQSettings;

class TQextScintilla;
class TQextScintillaLexer;


class UiGuiHighlighter : public TQObject
{
	TQ_OBJECT

	public:
		UiGuiHighlighter(TQextScintilla *parent);
		~UiGuiHighlighter();

		void turnHighlightOff();
		void turnHighlightOn();

		bool         readCurrentSettings();
		void         writeCurrentSettings();
		TQStringList getAvailableHighlighters();

	public slots:
		// The foreground color for style number \a style is set to \a color.  If
		// \a style is -1 then the color is set for all styles.
		void setColor(const TQColor &color, int style = -1);

		// The font for style number \a style is set to \a font.  If \a style is
		// -1 then the font is set for all styles.
		void setFont(const TQFont &font, int style = -1);

		// Sets the lexer that is responsible for the given \a extension.
		int setLexer(TQString extension);

		void setHighlighterByAction(TQAction *highlighterAction);

	private:
		bool                          m_highlightingIsOn;
		TQextScintilla               *m_qsciEditorParent;
		TQMap<int, TQFont>            m_fontForStyles;
		TQMap<int, TQColor>           m_colorForStyles;
		TQextScintillaLexer          *m_lexer;
		TQSettings                   *m_settings;
		TQMap<TQString, TQStringList> m_fileExtensions;
};

#endif // UIGUIHIGHLIGHTER_H
