/*
 * $Id: MachBunt.h,v 1.23 2004/03/23 15:34:45 llunak Exp $
 *
 */

#ifndef __KDE_SuSE_H
#define __KDE_SuSE_H

#include <tqvariant.h>
#include <tqlayout.h>
#include <tqbutton.h>
#include <tqbitmap.h>
#include <tqimage.h>
#include <kpixmap.h>
#include <kdecoration.h>
#include <kdecorationfactory.h>
class TQLabel;
class TQSpacerItem;
class TQHBoxLayout;

#define USE_BUT 		   1
#define PIX_HEIGHT        24
#define PIX_SIDE           8
#define PIX_CORNER_RADIUS  7
#define TOP_RESIZE_HEIGHT  6
#define BUTTON_RESIZE_SIZE 5
#define BORDER_LEFT        2
#define BORDER_RIGHT       2
#define BORDER_BOTTOM      6
#define TEXT_BORDER        3

namespace SuSEMachBunt
{

enum Buttons{ BtnMenu=0, BtnSticky, BtnHelp, BtnIconify, BtnMax,
	      BtnClose, BtnCount };

enum ButtonPos { ButtonLeft, ButtonMiddle, ButtonRight };

// [button number][inactive/active][std/mouseOver/buttonPressed][miniIcon]
extern KPixmap buttonPixmap[BtnCount][2][3][2];
extern bool titlebarResize, titlebarPlain, titlebarLogo, titlebarSidebar, titlebarNoPlainButtons;
extern double titlebarLenseButtonFlare;

KPixmap create_buttonPixmap( int x, int y, TQPixmap pix, TQPixmap bg, int active, int mouse );

class MachBunt;

class MachBuntButton : public TQButton 
{
	TQ_OBJECT

	public:
	    	MachBuntButton(MachBunt *client, const char *name,
                               int button, TQPixmap bgI, TQPixmap bgA, bool isMini=false,
                               const TQString& tip=NULL);
		virtual ~MachBuntButton();
		virtual void reset( unsigned long changed );
		void setBitmap(const unsigned char *bitmap);
		void setPixmap(const TQPixmap &p);
		void setTipText(const TQString &tip);
                void setPosition(ButtonPos pos);

		virtual TQSize sizeHint() const;
		int   last_button;
		KPixmap menuButtonPixmap[BtnCount][2][3][2];

	signals:
		void shapeMe(int);
                void mousePressedMove(TQMouseEvent*);

	protected:
		void mousePressEvent(TQMouseEvent* e);
		void mouseReleaseEvent(TQMouseEvent* e);
		virtual void drawButton(TQPainter *p);
		void drawButtonLabel(TQPainter *){;}
		void enterEvent(TQEvent *);
		void leaveEvent(TQEvent *);
		void mouseMoveEvent( TQMouseEvent *e );
                
                bool resizePosition( TQPoint pos );

		TQBitmap  deco;
		TQPixmap  pix;
		TQPixmap  menuPixmap;
		TQPixmap  bg[2];
		bool     menuBtn;
		bool     miniBtn;
		bool     pressed;
		int		 button;
		int		 state;
                ButtonPos position;

	private:
		KDecoration *client;
};

class MachBunt : public KDecoration
{
	TQ_OBJECT

	public:
		MachBunt(KDecorationBridge* bridge, KDecorationFactory* factory);
		virtual ~MachBunt();
		virtual void init();
		virtual void resize(const TQSize&);
		virtual bool eventFilter( TQObject* o, TQEvent* e );

	protected:
		virtual void          reset( unsigned long changed );
		virtual void          resizeEvent( TQResizeEvent* );
		virtual void          paintEvent( TQPaintEvent* );
		virtual void          showEvent( TQShowEvent* );
		virtual void          mouseDoubleClickEvent( TQMouseEvent * );
		virtual Position      mousePosition( const TQPoint& ) const;
		virtual void          captionChange();
		virtual void 	      desktopChange();
		virtual void 	      shadeChange() {};
		virtual void          maximizeChange();
		virtual void          activeChange();
		virtual void          iconChange();
		virtual void          calcHiddenButtons();
		virtual void borders(int&, int&, int&, int&) const;
		virtual TQSize minimumSize() const;
		virtual int  mapButton( const TQChar &c );
		virtual void doLayout();
		virtual void createButtons();

	signals:
		void oadChange(bool);
		void maxChange(bool);

	protected slots:
		void buttonPressed();
		void buttonReleased();
		void slotMaximize();
		void menuButtonPressed();
		void doShape(int x=0);
                void mouseMoveOnButtonPressed(TQMouseEvent*);

	private:
		bool isTool();

		MachBuntButton* button[ BtnCount ];
		TQPoint          buttonPressedPosition;
		int         	lastButtonWidth;
		int         	titleHeight;
		TQSpacerItem*	titlebar;
		bool        	hiddenItems;
		TQVBoxLayout*    windowLayout;
		TQBoxLayout*     topLayout;
		bool        	smallButtons;
		bool        	mouseOverButton;
};


class BuntFactory : public TQObject, public KDecorationFactory
{
  TQ_OBJECT

  public:

    BuntFactory() {};
    virtual ~BuntFactory() {};
    virtual KDecoration* createDecoration( KDecorationBridge* );
    virtual bool reset( unsigned long changed );
    virtual TQValueList< BorderSize > borderSizes() const;
};

};

#endif
