/***************************************************************************
    copyright            : (C) 2003-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef XSLTHANDLER_H
#define XSLTHANDLER_H

#include <tqmap.h>

// for xmlDocPtr
#include <libxml/tree.h>
// for xsltStyleSheetPtr
#include <libxslt/xsltInternals.h>

class KURL;
class TQDomDocument;

namespace Tellico {

/**
 * The XSLTHandler contains all the code which uses XSLT processing to generate HTML or to
 * translate to other formats.
 *
 * @author Robby Stephenson
 */
class XSLTHandler {

public:
  class XMLOutputBuffer {
  public:
    XMLOutputBuffer();
    ~XMLOutputBuffer();
    bool isValid() const { return (m_buf != 0); }
    xmlOutputBuffer* buffer() const { return m_buf; }
    TQString result() const { return m_res; }
  private:
    xmlOutputBuffer* m_buf;
    TQString m_res;
  };

  /**
   * @param xsltFile The XSLT file
   */
  XSLTHandler(const TQCString& xsltFile);
  /**
   * @param xsltURL The XSLT URL
   */
  XSLTHandler(const KURL& xsltURL);
  /**
   * @param xsltDoc The XSLT DOM document
   * @param xsltFile The XSLT file, should be a url?
   */
  XSLTHandler(const TQDomDocument& xsltDoc, const TQCString& xsltFile, bool translate=false);
  /**
   */
  ~XSLTHandler();

  bool isValid() const { return (m_stylesheet != NULL); }
  /**
   * Set the XSLT text
   *
   * @param dom The XSLT DOM document
   * @param xsltFile The XSLT file, should be a url?
   */
  void setXSLTDoc(const TQDomDocument& dom, const TQCString& xsltFile, bool translate=false);
  /**
   * Adds a param
   */
  void addParam(const TQCString& name, const TQCString& value);
  /**
   * Adds a string param
   */
  void addStringParam(const TQCString& name, const TQCString& value);
  void removeParam(const TQCString& name);
  const TQCString& param(const TQCString& name);
  /**
   * Processes text through the XSLT transformation.
   *
   * @param text The text to be transformed
   * @param encodedUTF8 Whether the text is encoded in utf-8 or not
   * @return The transformed text
   */
  TQString applyStylesheet(const TQString& text);

  static TQDomDocument& setLocaleEncoding(TQDomDocument& dom);

private:
  void init();
  TQString process();

  xsltStylesheetPtr m_stylesheet;
  xmlDocPtr m_docIn;
  xmlDocPtr m_docOut;

  TQMap<TQCString, TQCString> m_params;

  static int s_initCount;
};

} // end namespace
#endif
