/**********************************************************************
 This file is based on TQt Designer, Copyright (C) 2000 Trolltech AS. All rights reserved.

 This file may be distributed and/or modified under the terms of the
 GNU General Public License version 2 as published by the Free Software
 Foundation and appearing in the file LICENSE.GPL included in the
 packaging of this file.

 This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

 See http://www.trolltech.com/gpl/ for GPL licensing information.

 Modified for Kommander:
  (C) 2002-2003 Marc Britton <consume@optusnet.com.au>
  (C) 2004      Michal Rudolf <mrudolf@kdewebdev.org>

**********************************************************************/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include "metadatabase.h"

#include <tdeparts/dockmainwindow.h>
#include <kdockwidget.h>

#include <tqmap.h>
#include <tqguardedptr.h>
#include <tqobjectlist.h>

class ActionEditor;
class AssistProc;
class FindDialog;
class FormFile;
class FormWindow;
class GotoLineDialog;
class HierarchyView;
class TDEAction;
class TDEActionCollection;
class TDEProcess;
class TDERecentFilesAction;
class TDEToggleAction;
class TDEToolBar;
class KURL;
class PropertyEditor;
class TQCloseEvent;
class TQMenuBar;
class TQTimer;
class TQWidget;
class TQWorkspace;
class MessageLog;
class ReplaceDialog;
class Workspace;

#if defined(TQ_FULL_TEMPLATE_INSTANTIATION)
#include <tqtoolbar.h>
#else
class TQToolBar;
#endif
class Preferences;

namespace KParts {
  class PartManager;
}


class MainWindow : public KParts::DockMainWindow
{
    TQ_OBJECT
  

public:
    MainWindow( bool asClient );
    ~MainWindow();

    HierarchyView *objectHierarchy() const;
    Workspace *workspace() const;
    PropertyEditor *propertyeditor() const;
    ActionEditor *actioneditor() const;

    void resetTool();
    int currentTool() const;

    FormWindow *formWindow();

    bool unregisterClient( FormWindow *w );
    TQWidget *isAFormWindowChild( TQObject *o ) const;
    TQWidget *isAToolBarChild( TQObject *o ) const;

    void insertFormWindow( FormWindow *fw );
    TQWorkspace *qWorkspace() const;

    void popupFormWindowMenu( const TQPoint &gp, FormWindow *fw );
    void popupWidgetMenu( const TQPoint &gp, FormWindow *fw, TQWidget *w );

    TQPopupMenu *setupNormalHierarchyMenu( TQWidget *parent );
    TQPopupMenu *setupTabWidgetHierarchyMenu( TQWidget *parent, const char *addSlot, const char *removeSlot );

    FormWindow *openFormWindow( const TQString &fn, bool validFileName = true, FormFile *ff = 0 );
    
    void setGrid( const TQPoint &p );
    void setShowGrid( bool b );
    void setSnapGrid( bool b );
    TQPoint grid() const { return grd; }
    bool showGrid() const { return sGrid; }
    bool snapGrid() const { return snGrid && sGrid; }

    TQString documentationPath() const;

    static MainWindow *self;
    void saveAllTemp();

    TQString templatePath() const { return templPath; }

    bool isPreviewing() const { return previewing; }

    FormWindow *activeForm() const { return lastActiveFormWindow; }

    void setModified( bool b, TQWidget *window );
    void updateWorkspace();

    void formNameChanged( FormWindow *fw );

    int currentLayoutDefaultSpacing() const;
    int currentLayoutDefaultMargin() const;


public slots:
    void showProperties( TQObject *w );
    void updateProperties( TQObject *w );
    void showDialogHelp();
    void slotActivePartChanged(KParts::Part * );
    
signals:
    void addedFormFile(FormFile *);
    void removedFormFile(FormFile *);
    void currentToolChanged();
    void hasActiveForm( bool );
    void hasActiveWindow( bool );

    void formModified( bool );
    void formWindowsChanged();
    void formWindowChanged();

protected:
    bool eventFilter( TQObject *o, TQEvent *e );
    void closeEvent( TQCloseEvent *e );

public slots:
    void fileNew();
    void fileClose();
    void fileOpen();
    void fileOpen(const TQString &filename);
    void fileOpenRecent(const KURL& name);
    bool fileSave();
    bool fileSaveForm(); // not visible in menu, called from fileSave
    bool fileSaveAs();
    void fileSaveAll();
    void fileCreateTemplate();

    void editUndo();
    void editRedo();
    void editCut();
    void editCopy();
    void editPaste();
    void editDelete();
    void editSelectAll();
    void editLower();
    void editRaise();
    void editAdjustSize();
    void editLayoutHorizontal();
    void editLayoutVertical();
    void editLayoutHorizontalSplit();
    void editLayoutVerticalSplit();
    void editLayoutGrid();
    void editLayoutContainerHorizontal();
    void editLayoutContainerVertical();
    void editLayoutContainerGrid();
    void editBreakLayout();
    void editAccels();
    void editConnections();
    void editFindGlobal();
    
    void editFormSettings();
    void editPreferences();
    void editShortcuts();
    void editPlugins();
    void editExternalTool(int id);
    void editToolExited(TDEProcess*);
    void editToolOutput(TDEProcess*, char*, int);
    void configureEditor();

    void runForm();
    
private slots:
    void activeWindowChanged( TQWidget *w );
    void updateUndoRedo( bool, bool, const TQString &, const TQString & );

    void toolSelected();

    void clipboardChanged();
    void selectionChanged();

    void chooseDocPath();
    void windowsMenuActivated( int id );
    void setupWindowActions();
    void createNewTemplate();
    
    void closeRunningForm(TDEProcess* process);
    void slotCreateBackups();
    
private:
    void setupMDI();
    void setupEditActions();
    void setupToolActions();
    void setupLayoutActions();
    void setupFileActions();
    void setupSettingsActions();
    void setupRunActions();
    void setupHelpActions();
    void setupRMBMenus();

    void setupPropertyEditor();
    void setupHierarchyView();
    void setupWorkspace();
    void setupActionEditor();
    void setupMessageLog();
    void setupPlugins();

    TQWidget* previewFormInternal( TQStyle* style = 0, TQPalette* pal = 0 );

    void writeConfig();
    void readConfig();
    
    void setupRMBProperties( TQValueList<int> &ids, TQMap<TQString, int> &props, TQWidget *w );
    void handleRMBProperties( int id, TQMap<TQString, int> &props, TQWidget *w );
    void setupRMBSpecialCommands( TQValueList<int> &ids, TQMap<TQString, int> &commands, TQWidget *w );
    void handleRMBSpecialCommands( int id, TQMap<TQString, int> &commands, TQWidget *w );
    void setupRMBSpecialCommands( TQValueList<int> &ids, TQMap<TQString, int> &commands, FormWindow *w );
    void handleRMBSpecialCommands( int id, TQMap<TQString, int> &commands, FormWindow *w );
    bool openEditor( TQWidget *w, FormWindow *fw );
    void checkTempFiles();

    void addRecentlyOpened(const TQString &fn);
    TQWidget *findRealForm( TQWidget *w );

    TQString whatsThisFrom( const TQString &key );

private:
    PropertyEditor *propertyEditor;
    HierarchyView *hierarchyView;
    Workspace *wspace;
    TQWidget *lastPressWidget;
    TQWorkspace *qworkspace;
    KMenuBar *menubar;
    FormWindow *lastActiveFormWindow;
    bool breakLayout, layoutChilds, layoutSelected;
    TQPoint grd;
    bool sGrid, snGrid;
    bool restoreConfig;
    bool backPix;
    bool splashScreen;
    TQString docPath;
    
    TDEAction *actionEditUndo, *actionEditRedo, *actionEditCut, *actionEditCopy,
      *actionEditPaste, *actionEditDelete, *actionEditAdjustSize,
      *actionEditHLayout, *actionEditVLayout, *actionEditGridLayout,
      *actionEditSplitHorizontal, *actionEditSplitVertical,
      *actionEditSelectAll, *actionEditBreakLayout, *actionEditConnections,
      *actionEditLower, *actionEditRaise, *actionEditFindGlobal;
    
    TDEToggleAction* actionPointerTool, *actionConnectTool, *actionOrderTool;
    TDEAction* actionCurrentTool;
    TDEAction *actionEditFormSettings, *actionEditAccels;
    TDERecentFilesAction* actionRecent;
    
    TQPopupMenu *rmbWidgets;
    TQPopupMenu *rmbFormWindow;
    TQPopupMenu *windowMenu, *fileMenu;

    TQToolBar *layoutToolBar;
    TDEToolBar *fileTb;

    Preferences *prefDia;
    TQMap<TQString,TQString> propertyDocumentation;
    bool client;
    TQString templPath;
    ActionEditor *actionEditor;

    bool databaseAutoEdit;
    TQTimer *updateSlotsTimer;
    TQTimer *backupTimer;
    bool inDebugMode;
    TQObjectList debuggingForms;
    TQString lastOpenFilter;
    TQString menuHelpFile;
    AssistProc *assistant;
    
    bool previewing;
    MessageLog* messageLog;
    
    // Paths of external Kommander tools for Editor
    TQStringList m_editorTools;
    TQString m_toolOutput;
    KParts::PartManager *m_partManager;

    TQString m_fileName;
    TQString m_backupName;
    bool m_modified;

public:
    TQString lastSaveFilter;

};

#endif
