/**********************************************************************
** Copyright (C) 2000-2001 Trolltech AS.  All rights reserved.
**
** This file is part of TQt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid TQt Enterprise Edition or TQt Professional Edition
** licenses may use this file in accordance with the TQt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about TQt Commercial License Agreements.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#include <tqvariant.h> // HP-UX compiler needs this here

#include <kiconloader.h>
#include <kimageio.h>
#include <tdefiledialog.h>
#include <kimagefilepreview.h>
#include <klineedit.h>

#include "kdevdesigner_part.h"

#include "pixmapchooser.h"
#include "formwindow.h"
#if defined(DESIGNER) && !defined(RESOURCE)
#include "pixmapfunction.h"
#endif
#include "metadatabase.h"
#include "mainwindow.h"
#include "pixmapcollectioneditor.h"
#include "pixmapcollection.h"
#include "project.h"

#include <tqapplication.h>
#include <tqimage.h>
#include <tqpainter.h>
#include <tqlabel.h>
#include <tqpushbutton.h>
#include <tqiconview.h>

#if defined(DESIGNER)
static ImageIconProvider *imageIconProvider = 0;
#endif

PixmapView::PixmapView( TQWidget *parent )
    : TQScrollView( parent )
{
    viewport()->setBackgroundMode( PaletteBase );
}

void PixmapView::setPixmap( const TQPixmap &pix )
{
    pixmap = pix;
    resizeContents( pixmap.size().width(), pixmap.size().height() );
    viewport()->repaint( false );
}

void PixmapView::drawContents( TQPainter *p, int cx, int cy, int cw, int ch )
{
    p->fillRect( cx, cy, cw, ch, colorGroup().brush( TQColorGroup::Base ) );
    p->drawPixmap( 0, 0, pixmap );
}

void PixmapView::previewUrl( const TQUrl &u )
{
    if ( u.isLocalFile() ) {
	TQString path = u.path();
	TQPixmap pix( path );
	if ( !pix.isNull() )
	    setPixmap( pix );
    } else {
	tqWarning( "Previewing remote files not supported." );
    }
}

static void buildImageFormatList( TQString &filter, TQString &all )
{
    all = tqApp->translate( "qChoosePixmap", "All Pixmaps (" );
    for ( uint i = 0; i < TQImageIO::outputFormats().count(); i++ ) {
	TQString outputFormat = TQImageIO::outputFormats().at( i );
	TQString outputExtension;
	if ( outputFormat != "JPEG" )
	   outputExtension = outputFormat.lower();
	else
	    outputExtension = "jpg;*.jpeg";
	filter += TQString(tqApp->translate( "qChoosePixmap", "%1-Pixmaps (%2)\n" )).
		  arg( outputFormat ).arg( "*." + outputExtension);
	all += "*." + outputExtension + ";";
    }
    filter.prepend( all + tqApp->translate( "qChoosePixmap", ")\n" ) );
    filter += tqApp->translate( "qChoosePixmap", "All Files (*)" );

}
TQStringList qChoosePixmaps( TQWidget *parent )
{
/*    if ( !imageIconProvider && !TQFileDialog::iconProvider() )
	TQFileDialog::setIconProvider( ( imageIconProvider = new ImageIconProvider ) );

    TQString filter;
    TQString all;
    buildImageFormatList( filter, all );

    TQFileDialog fd( TQString(), filter, parent, 0, true );
    fd.setMode( TQFileDialog::ExistingFiles );
    fd.setContentsPreviewEnabled( true );
    PixmapView *pw = new PixmapView( &fd );
    fd.setContentsPreview( pw, pw );
    fd.setViewMode( TQFileDialog::List );
    fd.setPreviewMode( TQFileDialog::Contents );
    fd.setCaption( tqApp->translate( "qChoosePixmap", "Choose Images..." ) );
    if ( fd.exec() == TQDialog::Accepted )
	return fd.selectedFiles();
    return TQStringList();*/
    TQStringList mimetypes = KImageIO::mimeTypes( KImageIO::Reading );
    KFileDialog dlg(TQString(), mimetypes.join(" "), parent, "filedialog", true);
    dlg.setOperationMode( KFileDialog::Opening );
    dlg.setCaption( tqApp->translate( "qChoosePixmap", "Choose Images..." ) );
    dlg.setMode( KFile::Files );
    KImageFilePreview *ip = new KImageFilePreview( &dlg );
    dlg.setPreviewWidget( ip );
    if (dlg.exec())
        return dlg.selectedFiles();
    return TQStringList();
}

TQPixmap qChoosePixmap( TQWidget *parent, FormWindow *fw, const TQPixmap &old, TQString *fn )
{
#if defined(DESIGNER)
    if ( !fw || fw->savePixmapInline() ) {
/*	if ( !imageIconProvider && !TQFileDialog::iconProvider() )
	    TQFileDialog::setIconProvider( ( imageIconProvider = new ImageIconProvider ) );

	TQString filter;
	TQString all;
	buildImageFormatList( filter, all );

	TQFileDialog fd( TQString(), filter, parent, 0, true );
	fd.setContentsPreviewEnabled( true );
	PixmapView *pw = new PixmapView( &fd );
	fd.setContentsPreview( pw, pw );
	fd.setViewMode( TQFileDialog::List );
	fd.setPreviewMode( TQFileDialog::Contents );
	fd.setCaption( tqApp->translate( "qChoosePixmap", "Choose Pixmap" ) );
	if ( fd.exec() == TQDialog::Accepted ) {
	    TQPixmap pix( fd.selectedFile() );
	    if ( fn )
		*fn = fd.selectedFile();
	    MetaDataBase::setPixmapArgument( fw, pix.serialNumber(), fd.selectedFile() );
	    return pix;
	}*/
        TQStringList mimetypes = KImageIO::mimeTypes( KImageIO::Reading );
        KFileDialog dlg(TQString(), mimetypes.join(" "), parent, "filedialog", true);
        dlg.setOperationMode( KFileDialog::Opening );
        dlg.setCaption( tqApp->translate( "qChoosePixmap", "Choose Pixmap" ) );
        dlg.setMode( KFile::File );
        KImageFilePreview *ip = new KImageFilePreview( &dlg );
        dlg.setPreviewWidget( ip );
        if (dlg.exec())
        {
            TQPixmap pix( dlg.selectedURL().path() );
            if ( fn )
                *fn = dlg.selectedURL().path();
            MetaDataBase::setPixmapArgument( fw, pix.serialNumber(), dlg.selectedURL().path() );
            return pix;
        }
    } else if ( fw && fw->savePixmapInProject() ) {
	PixmapCollectionEditor dia( parent, 0, true );
	dia.setProject( fw->project() );
	dia.setChooserMode( true );
	dia.setCurrentItem( MetaDataBase::pixmapKey( fw, old.serialNumber() ) );
	if ( dia.exec() == TQDialog::Accepted ) {
	    TQPixmap pix( fw->project()->pixmapCollection()->pixmap( dia.viewPixmaps->currentItem()->text() ) );
	    MetaDataBase::setPixmapKey( fw, pix.serialNumber(), dia.viewPixmaps->currentItem()->text() );
	    return pix;
	}
    } else {
	PixmapFunction dia( parent, 0, true );
	TQObject::connect( dia.helpButton, TQ_SIGNAL( clicked() ), MainWindow::self, TQ_SLOT( showDialogHelp() ) );
	dia.labelFunction->setText( fw->pixmapLoaderFunction() + "(" );
	dia.editArguments->setText( MetaDataBase::pixmapArgument( fw, old.serialNumber() ) );
	dia.editArguments->setFocus();
	if ( dia.exec() == TQDialog::Accepted ) {
	    TQPixmap pix;
	    // we have to force the pixmap to get a new and unique serial number. Unfortunately detatch() doesn't do that
	    pix.convertFromImage( BarIcon( "designer_image.png", KDevDesignerPartFactory::instance() ).convertToImage() );

	    MetaDataBase::setPixmapArgument( fw, pix.serialNumber(), dia.editArguments->text() );
	    return pix;
	}
    }
#else
    Q_UNUSED( parent );
    Q_UNUSED( fw );
    Q_UNUSED( old );
#endif
    return TQPixmap();
}

ImageIconProvider::ImageIconProvider( TQWidget *parent, const char *name )
    : TQFileIconProvider( parent, name ), imagepm( BarIcon( "designer_image.png", KDevDesignerPartFactory::instance() ) )
{
    fmts = TQImage::inputFormats();
}

ImageIconProvider::~ImageIconProvider()
{
}

const TQPixmap * ImageIconProvider::pixmap( const TQFileInfo &fi )
{
    TQString ext = fi.extension().upper();
    if ( fmts.contains( ext ) ) {
	return &imagepm;
    } else {
	return TQFileIconProvider::pixmap( fi );
    }
}
