/***************************************************************************
*   Copyright (C) 2001-2002 by Bernd Gehrmann                             *
*   bernd@kdevelop.org                                                    *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/

#ifndef _MISC_H_
#define _MISC_H_

#include <tqcstring.h>
#include <tqmap.h>
#include <tqwidget.h>

/**
 * Very small helper class. It has just static methods.
 */
class AutoProjectTool
{
public:

	/**
	 * Loads the compiler options plugin for the given compiler, executes the dialog
	 * with some initial flags, and returns the new flags.
	 */
	static TQString execFlagsDialog( const TQString &compiler, const TQString &flags, TQWidget *parent );

	/**
	 * Returns the canonicalized version of a file name, i.e.
	 * the file name with special characters replaced by underscores
	 */
	static TQString canonicalize( const TQString &str );

	/**
	 * Parses a Makefile.am and stores its variable assignments
	 * in a map.
	 */
	static void parseMakefileam( const TQString &filename, TQMap<TQString, TQString> *variables );

	static void addToMakefileam( const TQString &filename, TQMap<TQString, TQString> variables );
	static void removeFromMakefileam( const TQString &filename, TQMap<TQString, TQString> variables );
	static void setMakefileam ( const TQString &fileName, TQMap<TQString, TQString> variables );

	static void addRemoveMakefileam(const TQString &fileName, TQMap<TQString, TQString> variables,  bool add);

	/**
	 * Parses configure.in and splits AC_OUTPUT into a TQStringList
	 */
	static TQStringList configureinLoadMakefiles( TQString configureinpath );

	/**
	 * Receives a TQStringList and puts it into
	 * configure.in as arguments to AC_OUTPUT
	 */
	static void configureinSaveMakefiles( TQString configureinpath, TQStringList makefiles );

};

#endif
