/*
 *  This file is part of the KDE project
 *  Copyright (C) 2002 Ian Reinhart Geiser <geiseri@kde.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License version 2.0 as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 *  $Id$
 */

#ifndef __KONQSIDEBARWEATHER_H__
#define __KONQSIDEBARWEATHER_H__

#include <konqsidebarplugin.h>
#include <tdeparts/part.h>
#include <tdeparts/factory.h>
#include <tdeparts/browserextension.h>
#include <tqdict.h>
#include <dcopobject.h>
#include <tqlayout.h>
#include <tqtimer.h>

class dockwidget;
class sidebarwidget;
class TQLabel;

class KonqSidebarWeather: public KonqSidebarPlugin, virtual public DCOPObject
{
    TQ_OBJECT

    K_DCOP
public:
    KonqSidebarWeather(TDEInstance* inst, TQObject* parent, TQWidget* widgetParent,
                        TQString& desktopName_, const char* name = 0);

    ~KonqSidebarWeather();
    virtual void* provides(const TQString&);
    void emitStatusBarText(const TQString&);
    virtual TQWidget *getWidget();

    k_dcop:
    virtual void refresh(TQString);

public slots:
    virtual void updateWidgets();

protected:
    virtual void handleURL(const KURL &url);
    virtual void handlePreview(const KFileItemList& items);
    virtual void handlePreviewOnMouseOver(const KFileItem& item);

private:
    bool startWeatherService();

    TQDict <TQLabel> m_labels;
    TQDict <dockwidget> m_widgets;
    sidebarwidget *m_container;
    TQTimer *timeOut;
};

#endif

