/***************************************************************************
 *   Copyright (C) 2005-2007 by Rajko Albrecht                             *
 *   ral@alwins-world.de                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/


#ifndef _TDESVN_H_
#define _TDESVN_H_

#include "tdesvn-config.h"

#include <tdeapplication.h>
#include <tdeparts/mainwindow.h>
#include <tqtimer.h>
#include <kbookmarkmanager.h>

class KURL;
class TDEAction;
class TDEActionMenu;
class TDEToggleAction;
class KBookmarkMenu;

/**
 * This class serves as the main window for tdesvn.  It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 * @author Rajko Albrecht <ral@alwins-world.de>
 * @version $Rev: 1229 $
 */
class tdesvn : public KParts::MainWindow,public KBookmarkOwner
{
    TQ_OBJECT
  
public:
    /**
     * Default Constructor
     */
    tdesvn();

    /**
     * Default Destructor
     */
    virtual ~tdesvn();

    virtual void openBookmarkURL (const TQString &_url);
    virtual TQString currentURL () const;
    void checkReload();

protected:
    /**
     * This function is called when it is time for the app to save its
     * properties for session management purposes.
     */
    void saveProperties(TDEConfig *);

    /**
     * This function is called when this app is restored.  The TDEConfig
     * object points to the session management config file that was saved
     * with @ref saveProperties
     */
    void readProperties(TDEConfig *);
    virtual bool queryExit();
    void enableClose(bool how);


public slots:
    virtual void slotUrlOpened(bool);
    virtual void loadRescent(const KURL&);
    virtual void load(const KURL&,bool);

private slots:
    void fileOpen();
    void fileNew();
    void fileClose();
    void optionsShowStatusbar();
    void changeStatusbar(const TQString&);
    void resetStatusBar();

private:
    void setupAccel();
    void setupActions();
    void connectActionCollection( TDEActionCollection *coll );
    void disconnectActionCollection( TDEActionCollection *coll );

    TDEActionMenu *m_FileMenu;
    TQString m_bookmarkFile;
    KBookmarkManager * m_BookmarkManager;
    TDEActionMenu* m_BookmarksActionmenu;
    TDEActionCollection*m_Bookmarkactions;
    KBookmarkMenu * m_pBookmarkMenu;
    KParts::ReadOnlyPart *m_part;
    TDEToggleAction *m_statusbarAction;

protected slots:
    virtual void optionsConfigureToolbars();
    virtual void optionsConfigureKeys();
    virtual void applyNewToolbarConfig();
    virtual void slotLoadLast(bool);
};

#endif // _TDESVN_H_
