/***************************************************************************
 *   Copyright (C) 2005-2007 by Rajko Albrecht                             *
 *   ral@alwins-world.de                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/
#ifndef TDEIOSVN_H
#define TDEIOSVN_H

#include "tdeiobytestream.h"

#include <tqstring.h>
#include <tqcstring.h>
#include <kurl.h>

#include <tdeio/global.h>
#include <tdeio/slavebase.h>


#include <sys/stat.h>
#include <tqvaluelist.h>

namespace TDEIO
{

class KioSvnData;

/**
@author Rajko Albrecht
*/
class tdeio_svnProtocol : public TDEIO::SlaveBase,public StreamWrittenCb
{
public:
    tdeio_svnProtocol(const TQCString &pool_socket, const TQCString &app_socket);
    virtual ~tdeio_svnProtocol();
    virtual void listDir (const KURL&url);
    virtual void stat(const KURL& url);
    virtual void get(const KURL& url);
    virtual void mkdir (const KURL &url, int permissions);
    virtual void mkdir (const KURL::List &urls, int permissions);
    virtual void rename(const KURL&src,const KURL&target,bool force);
    virtual void del(const KURL&url,bool isfile);
    virtual void copy(const KURL&src,const KURL&dest,int permissions,bool overwrite);
    virtual void checkout(const KURL&src,const KURL&target,const int rev, const TQString&revstring);
    virtual void svnlog(int,const TQString&,int, const TQString&, const KURL::List&);
    virtual void revert(const KURL::List&);
    virtual void wc_switch(const KURL&,const KURL&,bool,int,const TQString&);
    virtual void diff(const KURL&,const KURL&,int,const TQString&,int, const TQString&,bool);
    virtual void import( const KURL& repos, const KURL& wc);
    virtual void add(const KURL& wc);
    virtual void wc_delete(const KURL::List&);
    virtual void special(const TQByteArray& data);
    virtual void wc_resolve(const KURL&,bool);
    /* looked on tdeio::svn from tdesdk */
    enum KSVN_METHOD {
        /* KURL repository, KURL target, int revnumber, TQString revkind */
        SVN_CHECKOUT = 1,
        /* KURL wc, int revnumber, TQString revkind */
        /* refkind may empty or HEAD or START, will get parsed if revnumber is -1 */
        SVN_UPDATE = 2,
        /* KURL::List */
        SVN_COMMIT = 3,
        /* int revstart, TQString revstartstring, int revend, TQString revendstring, KURL::List */
        SVN_LOG=4,
        SVN_IMPORT=5,
        /* KURL */
        SVN_ADD=6,
        /*KURL::List */
        SVN_DEL=7,
        /* KURL::List */
        SVN_REVERT=8,
        /* KURL wc,bool checkRepos, bool recurse */
        SVN_STATUS=9,
        /* KURL::List */
        SVN_MKDIR=10,
        /* KURL, bool */
        SVN_RESOLVE=11,
        /* KURL working copy, KURL new_repository_url, bool recurse, int rev, TQString revstring */
        SVN_SWITCH=12,
        /* KURL uri1, KURL uri2, int r1, TQString rstring1, int r2, TQString rstring 2, bool recursive */
        SVN_DIFF=13
    };

    void contextProgress(long long int current, long long int max);
    virtual void streamWritten(const TDEIO::filesize_t current);
    virtual void streamPushData(TQByteArray);
    virtual void streamSendMime(KMimeMagicResult*mt);
    virtual void streamTotalSizeNull();

protected:
    virtual void commit(const KURL::List&);
    virtual void status(const KURL&,bool,bool);
    virtual void update(const KURL&,int,const TQString&);

private:
    KioSvnData*m_pData;
    bool createUDSEntry( const TQString& filename, const TQString& user, long long int size, bool isdir, time_t mtime, TDEIO::UDSEntry& entry);
    TQString makeSvnUrl(const KURL&url,bool check_wc=true);
    bool checkWc(const KURL&url);
    bool getLogMsg(TQString&);
protected:
    TQString getDefaultLog();
};

}

#endif
