echo "Creating $LOCATION_ROOT/${APP_NAME_LC}/${APP_NAME_LC}_part.cpp...";
cat << EOF > $LOCATION_ROOT/${APP_NAME_LC}/${APP_NAME_LC}_part.cpp
#include "${APP_NAME_LC}_part.h"

#include "${APP_NAME_LC}_part.moc"

#include <kinstance.h>
#include <tdeaction.h>
#include <kstdaction.h>
#include <tdefiledialog.h>
#include <tdeparts/genericfactory.h>

#include <tqfile.h>
#include <tqtextstream.h>
#include <tqmultilineedit.h>

typedef KParts::GenericFactory<${APP_NAME}Part> ${APP_NAME}PartFactory;
K_EXPORT_COMPONENT_FACTORY( lib${APP_NAME_LC}part, ${APP_NAME}PartFactory )

${APP_NAME}Part::${APP_NAME}Part( TQWidget *parentWidget, const char *widgetName,
                                  TQObject *parent, const char *name,
                                  const TQStringList & /*args*/ )
    : KParts::ReadWritePart(parent, name)
{
    // we need an instance
    setInstance( ${APP_NAME}PartFactory::instance() );

    // this should be your custom internal widget
    m_widget = new TQMultiLineEdit( parentWidget, widgetName );

    // notify the part that this is our internal widget
    setWidget(m_widget);

    // create our actions
    KStdAction::saveAs(this, TQT_SLOT(fileSaveAs()), actionCollection());
    KStdAction::save(this, TQT_SLOT(save()), actionCollection());

    // set our XML-UI resource file
    setXMLFile("${APP_NAME_LC}_part.rc");

    // we are read-write by default
    setReadWrite(true);

    // we are not modified since we haven't done anything yet
    setModified(false);
}

${APP_NAME}Part::~${APP_NAME}Part()
{
}

void ${APP_NAME}Part::setReadWrite(bool rw)
{
    // notify your internal widget of the read-write state
    m_widget->setReadOnly(!rw);
    if (rw)
        connect(m_widget, TQT_SIGNAL(textChanged()),
                this,     TQT_SLOT(setModified()));
    else
    {
        disconnect(m_widget, TQT_SIGNAL(textChanged()),
                   this,     TQT_SLOT(setModified()));
    }

    ReadWritePart::setReadWrite(rw);
}

void ${APP_NAME}Part::setModified(bool modified)
{
    // get a handle on our Save action and make sure it is valid
    TDEAction *save = actionCollection()->action(KStdAction::stdName(KStdAction::Save));
    if (!save)
        return;

    // if so, we either enable or disable it based on the current
    // state
    if (modified)
        save->setEnabled(true);
    else
        save->setEnabled(false);

    // in any event, we want our parent to do it's thing
    ReadWritePart::setModified(modified);
}

TDEAboutData *${APP_NAME}Part::createAboutData()
{
    // the non-i18n name here must be the same as the directory in
    // which the part's rc file is installed ('partrcdir' in the
    // Makefile)
    TDEAboutData *aboutData = new TDEAboutData("${APP_NAME_LC}part", I18N_NOOP("${APP_NAME}Part"), "${APP_VERSION}");
    aboutData->addAuthor("${AUTHOR}", 0, "${EMAIL}");
    return aboutData;
}

bool ${APP_NAME}Part::openFile()
{
    // m_file is always local so we can use TQFile on it
    TQFile file(m_file);
    if (file.open(IO_ReadOnly) == false)
        return false;

    // our example widget is text-based, so we use TQTextStream instead
    // of a raw TQDataStream
    TQTextStream stream(&file);
    TQString str;
    while (!stream.eof())
        str += stream.readLine() + "\n";

    file.close();

    // now that we have the entire file, display it
    m_widget->setText(str);

    // just for fun, set the status bar
    emit setStatusBarText( m_url.prettyURL() );

    return true;
}

bool ${APP_NAME}Part::saveFile()
{
    // if we aren't read-write, return immediately
    if (isReadWrite() == false)
        return false;

    // m_file is always local, so we use TQFile
    TQFile file(m_file);
    if (file.open(IO_WriteOnly) == false)
        return false;

    // use TQTextStream to dump the text to the file
    TQTextStream stream(&file);
    stream << m_widget->text();

    file.close();

    return true;
}

void ${APP_NAME}Part::fileSaveAs()
{
    // this slot is called whenever the File->Save As menu is selected,
    TQString file_name = KFileDialog::getSaveFileName();
    if (file_name.isEmpty() == false)
        saveAs(file_name);
}

