/***************************************************************************
                       pluginmanager-configuration.cpp  -  description
                             -------------------
    begin                : Thu Sep 30 2004
    copyright            : (C) 2004 by Martin Witte
    email                : witte@kawo1.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "pluginmanager-configuration-ui.h"
#include "include/pluginmanager-configuration.h"
#include "include/tderadioapp.h"
#include "include/pluginmanager.h"

#include <tdelistbox.h>
#include <tdelistview.h>
#include <kpushbutton.h>
#include <kurlrequester.h>
#include <kinputdialog.h>

#include <tqcheckbox.h>

PluginManagerConfiguration::PluginManagerConfiguration(TQWidget *parent, TDERadioApp *app, PluginManager *pm)
  : PluginManagerConfigurationUI(parent),
    m_Application(app),
    m_PluginManager(pm),
    m_dirty(true)
{
    noticePluginLibrariesChanged();
    noticePluginsChanged();

    TQObject::connect(btnAddLibrary,           TQT_SIGNAL(clicked()),     this, TQT_SLOT(slotAddLibrary()));
    TQObject::connect(btnRemoveLibrary,        TQT_SIGNAL(clicked()),     this, TQT_SLOT(slotRemoveLibrary()));
    TQObject::connect(btnNewPluginInstance,    TQT_SIGNAL(clicked()),     this, TQT_SLOT(slotNewPluginInstance()));
    TQObject::connect(btnRemovePluginInstance, TQT_SIGNAL(clicked()),     this, TQT_SLOT(slotRemovePluginInstance()));
    TQObject::connect(cbShowProgressBar,       TQT_SIGNAL(toggled(bool)), this, TQT_SLOT(slotSetDirty()));

    slotCancel();
}


PluginManagerConfiguration::~PluginManagerConfiguration ()
{
}


void PluginManagerConfiguration::noticePluginLibrariesChanged()
{
    listPluginLibraries->clear();
    const TQMap<TQString, PluginLibraryInfo> &libs = m_Application->getPluginLibraries();
    TQMapConstIterator<TQString,PluginLibraryInfo> end = libs.end();
    for (TQMapConstIterator<TQString,PluginLibraryInfo> it = libs.begin(); it != end; ++it) {
        listPluginLibraries->insertItem(it.key());
    }

    listPluginClasses->clear();
    const TQMap<TQString, PluginClassInfo> &classes = m_Application->getPluginClasses();
    TQMapConstIterator<TQString, PluginClassInfo> end_cls = classes.end();
    for (TQMapConstIterator<TQString, PluginClassInfo> it = classes.begin(); it != end_cls; ++it) {
        listPluginClasses->insertItem(new TDEListViewItem(listPluginClasses, it.key(), (*it).description));
    }

    noticePluginsChanged();
}


void PluginManagerConfiguration::noticePluginsChanged()
{
    listPluginInstances->clear();
    const PluginList &plugins = m_PluginManager->plugins();
    const TQMap<TQString, PluginClassInfo> &classes = m_Application->getPluginClasses();

    for (PluginIterator it(plugins); it.current(); ++it) {
        TQString class_name = it.current()->pluginClassName();
        if (classes.contains(class_name)) {
            TQString obj_name   = it.current()->name();
            listPluginInstances->insertItem(new TDEListViewItem(listPluginInstances, class_name, obj_name, classes[class_name].description));
        }
    }
}


void PluginManagerConfiguration::slotOK()
{
    if (m_dirty) {
        m_PluginManager->showProgressBar(cbShowProgressBar->isChecked());
        m_dirty = false;
    }
}


void PluginManagerConfiguration::slotCancel()
{
    if (m_dirty) {
        cbShowProgressBar->setChecked(m_PluginManager->showsProgressBar());
        noticePluginLibrariesChanged();
        noticePluginsChanged();
        m_dirty = false;
    }
}


void PluginManagerConfiguration::slotAddLibrary()
{
    slotSetDirty();
    TQString url = editPluginLibrary->url();
    if (m_Application && url.length())
        m_Application->LoadLibrary(url);
}


void PluginManagerConfiguration::slotRemoveLibrary()
{
    slotSetDirty();
    if (m_Application) {
        TQString lib = listPluginLibraries->currentText();
        if (lib.length()) {
            m_Application->UnloadLibrary(lib);
        }
    }
}


void PluginManagerConfiguration::slotNewPluginInstance()
{
    slotSetDirty();
    if (m_Application && m_PluginManager) {
        TQListViewItem *item = listPluginClasses->currentItem();
        TQString class_name = item ? item->text(0) : TQString();
        bool ok = false;
        int default_object_id = 1;
        while (m_PluginManager->getPluginByName(class_name + TQString::number(default_object_id)))
            ++default_object_id;

        TQString object_name = KInputDialog::getText(i18n("Enter Plugin Instance Name"),
                                                    i18n("Instance Name"),
                                                    class_name + TQString::number(default_object_id),
                                                    &ok);
        if (ok && class_name.length() && object_name.length())
            m_Application->CreatePlugin(m_PluginManager, class_name, object_name);
    }
}


void PluginManagerConfiguration::slotRemovePluginInstance()
{
    slotSetDirty();
    if (m_Application && m_PluginManager) {
        TQListViewItem *item = listPluginInstances->currentItem();
        TQString object_name = item ? item->text(1) : TQString();
        if (object_name.length())
            m_PluginManager->deletePluginByName(object_name);
    }
}


void PluginManagerConfiguration::slotSetDirty()
{
    m_dirty = true;
}


#include "pluginmanager-configuration.moc"
