/*
    This file is part of KAddressBook.
    Copyright (c) 2003 Tobias Koenig <tokoe@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/

#include <tqlayout.h>

#include <tdeabc/secrecy.h>
#include <kcombobox.h>
#include <kdialog.h>

#include "secrecywidget.h"

SecrecyWidget::SecrecyWidget( TQWidget *parent, const char *name )
  : TQWidget( parent, name )
{
  TQVBoxLayout *layout = new TQVBoxLayout( this, KDialog::marginHint(),
                                         KDialog::spacingHint() );
  mSecrecyCombo = new KComboBox( this );
  layout->addWidget( mSecrecyCombo );

  const TDEABC::Secrecy::TypeList list = TDEABC::Secrecy::typeList();
  TDEABC::Secrecy::TypeList::ConstIterator it;
  for ( it = list.begin(); it != list.end(); ++it )
    mSecrecyCombo->insertItem( TDEABC::Secrecy::typeLabel( *it ), *it );

  connect( mSecrecyCombo, TQ_SIGNAL( activated( const TQString& ) ),
           TQ_SIGNAL( changed() ) );
}

SecrecyWidget::~SecrecyWidget()
{
}

void SecrecyWidget::setReadOnly( bool readOnly )
{
  mSecrecyCombo->setEnabled( !readOnly );
}

void SecrecyWidget::setSecrecy( const TDEABC::Secrecy &secrecy )
{
  if ( secrecy.type() != TDEABC::Secrecy::Invalid )
    mSecrecyCombo->setCurrentItem( secrecy.type() );
}

TDEABC::Secrecy SecrecyWidget::secrecy() const
{
  TDEABC::Secrecy secrecy;
  secrecy.setType( mSecrecyCombo->currentItem() );

  return secrecy;
}

#include "secrecywidget.moc"
