/*
    This file is part of KAddressBook.
    Copyright (c) 2003 Tobias Koenig <tokoe@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/

#ifndef KABLOCK_H
#define KABLOCK_H

namespace TDEABC {
class AddressBook;
class Resource;
class Ticket;
}

typedef struct {
  TDEABC::Ticket *ticket;
  uint counter;
} LockEntry;

class KABLock
{
  public:
    ~KABLock();

    static KABLock *self( TDEABC::AddressBook *ab );

    bool lock( TDEABC::Resource* );
    bool unlock( TDEABC::Resource* );

  protected:
    KABLock( TDEABC::AddressBook *ab );

  private:
    static KABLock *mSelf;

    TQMap<TDEABC::Resource*, LockEntry> mLocks;
    TDEABC::AddressBook *mAddressBook;
};

#endif
