/*
  Copyright (C) 2004 Nadeem Hasan <nhasan@kde.org>
            (C) 2001 by Stefan Winter <mail@stefan-winter.de>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this library; see the file COPYING.  If not, write to
  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
  Boston, MA 02110-1301, USA.
*/

#ifndef KCMWIFI_H
#define KCMWIFI_H

#include <tdecmodule.h>

#include <tqstring.h>

class IfConfigPage;
class MainConfig;
class TQTabWidget;
class KProcIO;

class KCMWifi : public TDECModule
{
    Q_OBJECT
  
public:
  KCMWifi (TQWidget * parent, const char *name, const TQStringList &);
  ~KCMWifi ();

  void load();
  void save();
  void defaults();
  int buttons();

  static void activate();
  IfConfigPage* addConfigTab( int count, bool vendor );
  void delConfigTab( int count );

  static const int vendorBase = 10;

  virtual TQString handbookSection() const;

protected slots:
  void slotActivate();
  void slotChanged();

private:
  MainConfig *m_mainConfig;
  IfConfigPage *m_ifConfigPage[ 15 ]; // that makes 5 vendor configs
  TQTabWidget* tabs;
  int m_activeVendorCount;
};

#endif // KCMWIFI_H
