#ifndef SERVERDATATYPE_H
#define SERVERDATATYPE_H

#include <tqptrlist.h>
#include <tqstring.h>

class port
{

public:
  port( const TQString &portnum ) { p=portnum; }
  TQString portnum() const { return p; }

private:
  TQString p;

};


class Server
{

public:
    Server( const TQString &group,
	    const TQString &server,
	    TQPtrList<port> ports,
	    const TQString &serverdesc,
	    const TQString &script,
	    const TQString &password  = TQString(),
            bool dossl = false
	) {
          g=group; s=server; p=ports; sd=serverdesc; sc=script;
	  pass=password;
	  ssl = dossl;
	  p.setAutoDelete(TRUE);
          }
  TQString group() const      { return g; }
  TQString server() const     { return s; }
  TQPtrList<port> ports() const      { return p; }
  TQString serverdesc() const { return sd; }
  TQString script() const     { return sc; }
  TQString password() const   { return pass; }
  bool    usessl() const     { return ssl; }

private:
  TQString     g;
  TQString     s;
  TQPtrList<port> p;
  TQString     sd;
  TQString     sc;
  TQString     pass;
  bool        ssl;

};

#endif
