/***************************************************************************
                          threads.h  -  threads for kvncview
                             -------------------
    begin                : Thu May 09 16:01:42 CET 2002
    copyright            : (C) 2015 Timothy Pearson <kb9vqf@pearsoncomputing.net>
                           (C) 2002 by Tim Jansen
    email                : tim@tjansen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef THREADS_H
#define THREADS_H

#include <tqthread.h>
#include <tqregion.h>
#include <tqrect.h>
#include <tqmutex.h>
#include <tqwaitcondition.h>
#include <tqevent.h>
#include <tqvaluelist.h>
#include <tqdatetime.h>
#include <tqimage.h>

#include <stdlib.h> 

#include "events.h"

extern "C" {
#include <rfb/rfbclient.h>
}

class KVncView;

enum EventType {
	MouseEventType,
	KeyEventType
};


struct MouseEvent {
	int x, y, buttons;
};

struct KeyEvent {
	unsigned int k;
	bool down;
};

struct InputEvent {
	EventType type;
	union {
		MouseEvent m;
		KeyEvent k;
	} e;
};

class ControllerThreadObject : public TQObject {
	Q_OBJECT

	public:
		ControllerThreadObject(KVncView *v, volatile bool &quitFlag);
		~ControllerThreadObject();

		enum RemoteViewStatus status();	

		void setImage(const TQImage &img);
		const TQImage image(int x = 0, int y = 0, int w = 0, int h = 0);
		void authenticationResults(int resultCode);
		void networkStatus(int statusCode);

		void setScaling(int w, int h);
		void queueDrawRegion(int x, int y, int w, int h);

		rfbClient *cl;
	
	public slots:
		void run();
	
	public:
		void queueMouseEvent(int x, int y, int buttonMask);
		void queueKeyEvent(unsigned int k, bool down);
		void queueClientCut(const TQString &text);

	private:
		KVncView *m_view;
		TQImage m_image;
		TQImage m_scaledImage;
		TQMutex mutex;
		enum RemoteViewStatus m_status;
		volatile bool &m_quitFlag;

		bool m_scaling;
		int m_scalingWidth;
		int m_scalingHeight;
		bool m_resizeEntireFrame;
	
		// all things that can be send follow:
		TQValueList<InputEvent> m_inputEvents; // list of unsent input events
	
		void changeStatus(RemoteViewStatus s);
		void sendFatalError(ErrorCode s);
};



#endif
