/*
 *
 *              kPPP: A pppd Front End for the KDE project
 *
 * $Id$
 *              Copyright (C) 1997 Bernd Johannes Wuebben
 *                      wuebben@math.cornell.edu
 *
 * based on EzPPP:
 * Copyright (C) 1997  Jay Painter
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */


#ifndef _EDIT_H_
#define _EDIT_H_

#include <tqdialog.h>
#include <tqpushbutton.h>
#include <tqgroupbox.h> 
#include <tqscrollbar.h>
#include <tqcombobox.h>
#include <tqlineedit.h>
#include <tqlistbox.h>
#include <tqradiobutton.h>
#include <tqbuttongroup.h>
#include <tqcheckbox.h>
#include <tqlabel.h>
#include <kdialogbase.h>
#include "scriptedit.h"
#include "kpppconfig.h"
#include "pppdargs.h"

class IPLineEdit;

class DialWidget : public TQWidget {
  Q_OBJECT
  
public:
  DialWidget( TQWidget *parent=0, bool isnewaccount = true, const char *name=0 );
  ~DialWidget() {}

public slots:
  bool save();
  void pppdargsbutton();
  void numbersChanged();
  void cbtypeChanged(int);
  void selectionChanged(int);
  void addNumber();
  void delNumber();
  void upNumber();
  void downNumber();
  
private:
  TQLineEdit *connectname_l;
  TQLabel *connect_label;
  TQLabel *number_label;
  TQPushButton *pppdargs;
  TQComboBox *auth;
  TQLabel *auth_l;
  TQCheckBox *store_password;

  // callback support
  TQComboBox *cbtype;
  TQLabel *cbtype_l;
  TQLineEdit *cbphone;
  TQLabel *cbphone_l;
  // for the phonenumber selection
  TQPushButton *add, *del, *up, *down;
  TQListBox *numbers;
};


/////////////////////////////////////////////////////////////////////////////
//
// tab-window to select what to execute when
//
/////////////////////////////////////////////////////////////////////////////
class ExecWidget : public TQWidget {
  Q_OBJECT
  
public:
  ExecWidget(TQWidget *parent=0, bool isnewaccount=true, const char *name=0);

public slots:
  bool save();

private:
  TQLineEdit *before_connect;
  TQLabel *before_connect_l;

  TQLineEdit *command;
  TQLabel *command_label;

  TQLineEdit *predisconnect;
  TQLabel *predisconnect_label;

  TQLineEdit *discommand;
  TQLabel *discommand_label;
};


class IPWidget : public TQWidget {
  Q_OBJECT
  
public:
  IPWidget( TQWidget *parent=0, bool isnewaccount = true, const char *name=0 );
  ~IPWidget() {}

public slots:
  void save();

protected slots:
  void hitIPSelect( int );
  void autoname_t(bool on);

private:
  TQLabel *ipaddress_label;
  TQLabel *sub_label;
  TQGroupBox *box1;
  TQVGroupBox *box;

  TQButtonGroup *rb;
  TQRadioButton *dynamicadd_rb;
  TQRadioButton *staticadd_rb;

  IPLineEdit *ipaddress_l;
  IPLineEdit *subnetmask_l;

  TQCheckBox *autoname;
};


class DNSWidget : public TQWidget {
  Q_OBJECT
  
public:
  DNSWidget( TQWidget *parent=0, bool isnewaccount = true, const char *name=0 );
  ~DNSWidget() {}

public slots:
  void save();

protected slots:
  void adddns();
  void removedns();
  void DNS_Edit_Changed(const TQString &);
  void DNS_Entry_Selected(int);
  void DNS_Mode_Selected(int);

private:
  TQLabel *conf_label;
  TQButtonGroup *bg;
  TQRadioButton *autodns, *mandns;
  TQLabel *dns_label;
  TQLabel *servers_label;
  IPLineEdit *dnsipaddr;
  TQPushButton *add;
  TQPushButton *remove;
  TQListBox *dnsservers;
  TQLineEdit *dnsdomain;
  TQLabel *dnsdomain_label;
  TQCheckBox *exdnsdisabled_toggle;
};


class GatewayWidget : public TQWidget {
  Q_OBJECT
  
public:
  GatewayWidget( TQWidget *parent=0, bool isnewaccount = true, const char *name=0 );
  ~GatewayWidget() {}

public slots:
  void save();

private slots:
  void hitGatewaySelect( int );

private:
  TQGroupBox *box;
  TQLabel *gate_label;
  TQGroupBox *box1;
  TQButtonGroup *rb;
  TQRadioButton *defaultgateway;
  TQRadioButton *staticgateway;
  IPLineEdit *gatewayaddr;
  TQCheckBox *defaultroute;
};


class ScriptWidget : public TQWidget {
  Q_OBJECT
  
public:
  ScriptWidget( TQWidget *parent=0, bool isnewaccount = true, const char *name=0 );
  ~ScriptWidget() {}

public slots:
  void save();
  bool check();

private slots:
  void addButton();
  void insertButton();
  void removeButton();

  //signals linked to the scroll bar
  void scrolling(int);

  //signals to keep the two listboxes highlighted in sync
  void slhighlighted(int);
  void stlhighlighted(int);

private:
  void adjustScrollBar();

  ScriptEdit *se;
  TQPushButton *add;
  TQPushButton *remove;
  TQPushButton *insert;
  TQListBox *sl, *stl;
  
  TQScrollBar *slb;
};


/////////////////////////////////////////////////////////////////////////////
//
// Used to specify a new phone number
//
/////////////////////////////////////////////////////////////////////////////
class PhoneNumberDialog : public KDialogBase {
  Q_OBJECT
  
public:
  PhoneNumberDialog(TQWidget *parent = 0);
  
  TQString phoneNumber();

private slots:
  void textChanged(const TQString &);

private: 
  TQLineEdit *le;
};


#endif
