/*
 *
 *            kPPP: A pppd front end for the KDE project
 *
 * $Id$
 *
 *            Copyright (C) 1997 Bernd Johannes Wuebben
 *                   wuebben@math.cornell.edu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef _CONWINDOW_H_
#define _CONWINDOW_H_


#include <tqtimer.h>
#include <tqpushbutton.h>
#include <tqlabel.h>
#include <tqdialog.h>
#include <tqframe.h>
#include <tqevent.h>
#include <tqlayout.h>

class PPPStats;

class ConWindow : public TQWidget {
Q_OBJECT
  

public:
  ConWindow(TQWidget *parent, const char *name,TQWidget *main, PPPStats *st);
  ~ConWindow();

protected:
  void closeEvent( TQCloseEvent *e );
  bool event( TQEvent *e );

private slots:
  void timeclick();
  void dock();

public:
  void setConnectionSpeed(const TQString&);
  void startClock();
  void stopClock();
  void accounting(bool); // show/ hide accounting info

public slots:
  void slotAccounting(TQString, TQString);

private:
  TQLabel *info1;
  TQLabel *info2;
  TQPushButton *cancelbutton;
  TQPushButton *statsbutton;
  TQString prettyPrintVolume(unsigned int);
  int minutes;
  int seconds;
  int hours;
  int days;
  TQFrame *fline;
  TQLabel *timelabel1;
  TQLabel *timelabel2;
  TQLabel *total_bill, *total_bill_l;
  TQLabel *session_bill, *session_bill_l;
  TQString caption_string;
  TQString time_string2;
  TQString time_string;
  TQTimer *clocktimer;
  TQVBoxLayout *tl1;
  TQLabel *vollabel;
  TQLabel *volinfo;
  PPPStats *stats;
  bool accountingEnabled;
  bool volumeAccountingEnabled;
};


#endif





