/*
  icqaccount.h  -  ICQ Account Class Header

  Copyright (c) 2002 by Chris TenHarmsel            <tenharmsel@staticmethod.net>
  Copyright (c) 2004 by Richard Smith               <kde@metafoo.co.uk>
  Kopete    (c) 2002-2004 by the Kopete developers  <kopete-devel@kde.org>

  *************************************************************************
  *                                                                       *
  * This program is free software; you can redistribute it and/or modify  *
  * it under the terms of the GNU General Public License as published by  *
  * the Free Software Foundation; either version 2 of the License, or     *
  * (at your option) any later version.                                   *
  *                                                                       *
  *************************************************************************

*/

#ifndef ICQACCOUNT_H
#define ICQACCOUNT_H

#include "oscaraccount.h"
#include "oscarmyselfcontact.h"

#include "icqpresence.h"
#include "oscartypeclasses.h"

class TDEAction;
namespace Kopete { class AwayAction; }
class ICQProtocol;
class ICQAccount;
class OscarVisibilityDialog;

class ICQMyselfContact : public OscarMyselfContact
{
Q_OBJECT
  
public:
	ICQMyselfContact( ICQAccount *acct );
	void userInfoUpdated();

public slots:
	void receivedShortInfo( const TQString& );
	void fetchShortInfo();
};


class ICQAccount : public OscarAccount
{
Q_OBJECT
  

public:
	ICQAccount( Kopete::Protocol *parent, TQString accountID, const char *name = 0L );
	virtual ~ICQAccount();

	ICQProtocol *protocol();

	// Accessor method for the action menu
	virtual TDEActionMenu* actionMenu();

	/** Reimplementation from Kopete::Account */
	void setOnlineStatus( const Kopete::OnlineStatus&, const TQString& );

	virtual void setAway( bool away, const TQString &awayReason );

	void connectWithPassword( const TQString &password );

	void setUserProfile( const TQString &profile );

protected:
	virtual OscarContact *createNewContact( const TQString &contactId, Kopete::MetaContact *parentContact, const SSI& ssiItem );

	virtual TQString sanitizedMessage( const TQString& message );

protected slots:
	virtual void disconnected( DisconnectReason reason );


private:
	ICQ::Presence presence();

	void setInvisible( ICQ::Presence::Visibility );
	void setPresenceType( ICQ::Presence::Type, const TQString &awayMessage = TQString() );
	void setPresenceTarget( const ICQ::Presence &presence, const TQString &message = TQString() );

	//const unsigned long fullStatus( const unsigned long plainStatus );

private slots:
	void slotToggleInvisible();

	void slotSetVisiblility();
	void slotVisibilityDialogClosed();

	void slotGlobalIdentityChanged( const TQString& key, const TQVariant& value );

	void slotBuddyIconChanged();

private:
	bool mWebAware;
	bool mHideIP;
	TQString mInitialStatusMessage;
	OscarVisibilityDialog* m_visibilityDialog;
};

#endif
