/*
 oscarprotocol.h  -  Oscar Protocol Plugin

 Copyright (c) 2002 by Tom Linsky <twl6@po.cwru.edu>
 Copyright (c) 2005 by Matt Rogers <mattr@kde.org>
 Kopete    (c) 2002 by the Kopete developers  <kopete-devel@kde.org>

 *************************************************************************
 *                                                                       *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation; either version 2 of the License, or     *
 * (at your option) any later version.                                   *
 *                                                                       *
 *************************************************************************
 */

#ifndef AIMPROTOCOL_H
#define AIMPROTOCOL_H

#include "kopeteprotocol.h"
#include "kopetecontactproperty.h"
#include "kopetemimetypehandler.h"
#include "kopeteonlinestatus.h"

#include <tqmap.h>

namespace Kopete
{
class OnlineStatus;
}

class AIMProtocolHandler : public Kopete::MimeTypeHandler
{
public:
	AIMProtocolHandler();
	void handleURL( const KURL & url ) const;
};

class AIMProtocol : public Kopete::Protocol
{
	Q_OBJECT
  

public:
	AIMProtocol( TQObject *parent, const char *name, const TQStringList &args );
	virtual ~AIMProtocol();
	/**
	 * Return the active instance of the protocol
	 * because it's a singleton, can only be used inside AIM classes, not in oscar lib
	 */
	static AIMProtocol *protocol();

	bool canSendOffline() const { return false; }

	virtual Kopete::Contact *deserializeContact( Kopete::MetaContact *metaContact,
	                                             const TQMap<TQString, TQString> &serializedData,
	                                             const TQMap<TQString, TQString> &addressBookData );
	
	AddContactPage*createAddContactWidget( TQWidget *parent, Kopete::Account *account );
	KopeteEditAccountWidget* createEditAccountWidget( Kopete::Account *account, TQWidget *parent );
	Kopete::Account* createNewAccount( const TQString &accountId );

	/**
	 * The set of online statuses that AIM contacts can have
	 */
	const Kopete::OnlineStatus statusOnline;
	const Kopete::OnlineStatus statusOffline;
	const Kopete::OnlineStatus statusAway;
	const Kopete::OnlineStatus statusWirelessOnline;
	const Kopete::OnlineStatus statusWirelessAway;
	const Kopete::OnlineStatus statusConnecting;

	const Kopete::ContactPropertyTmpl awayMessage;
	const Kopete::ContactPropertyTmpl clientFeatures;
	const Kopete::ContactPropertyTmpl clientProfile;
	const Kopete::ContactPropertyTmpl iconHash;

private:
	/** The active instance of oscarprotocol */
	static AIMProtocol *protocolStatic_;
	AIMProtocolHandler protohandler;
};

#endif 
