/*
    gwcontactlist.cpp - Kopete GroupWise Protocol

    Copyright (c) 2005      SUSE Linux Products GmbH	 	 http://www.suse.com

    Kopete    (c) 2002-2005 by the Kopete developers <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This library is free software; you can redistribute it and/or         *
    * modify it under the terms of the GNU General Public                   *
    * License as published by the Free Software Foundation; either          *
    * version 2 of the License, or (at your option) any later version.      *
    *                                                                       *
    *************************************************************************
*/

#include <tqobjectlist.h>

#include <kdebug.h>

#include "gwcontactlist.h"
#include "gwerror.h" //debug area

GWContactList::GWContactList( TQObject * parent )
 : TQObject( parent ), rootFolder( new GWFolder( this, 0, 0, TQString() ) )
{  }

GWFolder * GWContactList::addFolder( unsigned int id, unsigned int sequence, const TQString & displayName )
{
	if ( rootFolder )
		return new GWFolder( rootFolder, id, sequence, displayName );
	else
		return 0;
}

GWContactInstance * GWContactList::addContactInstance( unsigned int id, unsigned int parent, unsigned int sequence, const TQString & displayName, const TQString & dn )
{
	TQObjectList * l = queryList( "GWFolder", 0, false, true );
	TQObjectListIt it( *l ); // iterate over the buttons
    TQObject *obj;
	GWContactInstance * contact = 0;
    while ( (obj = it.current()) != 0 )
	{
		GWFolder * folder = ::tqqt_cast< GWFolder * >( obj );
		if ( folder && folder->id == parent )
		{
			contact = new GWContactInstance( folder, id, sequence, displayName, dn );
			break;
		}
		++it;
	}
	delete l;
	return contact;
}

GWFolder * GWContactList::findFolderById( unsigned int id )
{
	TQObjectList * l = queryList( "GWFolder", 0, false, true );
	TQObjectListIt it( *l ); // iterate over the buttons
    TQObject *obj;
	GWFolder * candidate, * folder = 0;
    while ( (obj = it.current()) != 0 )
	{
		candidate = ::tqqt_cast< GWFolder * >( obj );
		if ( candidate->id == id )
		{
			folder = candidate;
			break;
		}
		++it;
	}
	delete l;
	return folder;
}

GWFolder * GWContactList::findFolderByName( const TQString & displayName )
{
	TQObjectList * l = queryList( "GWFolder", 0, false, true );
	TQObjectListIt it( *l ); // iterate over the buttons
    TQObject *obj;
	GWFolder *  folder = 0;
    while ( (obj = it.current()) != 0 )
	{
		GWFolder * candidate = ::tqqt_cast< GWFolder * >( obj );
		if ( candidate->displayName == displayName )
		{
			folder = candidate;
			break;
		}
		++it;
	}
	delete l;
	return folder;
}

int GWContactList::maxSequenceNumber()
{
	TQObjectList * l = queryList( "GWFolder", 0, false, true );
	TQObjectListIt it( *l ); // iterate over the buttons
	TQObject *obj;
	unsigned int sequence = 0;
	while ( (obj = it.current()) != 0 )
	{
		GWFolder * current = ::tqqt_cast< GWFolder * >( obj );
		sequence = TQMAX( sequence, current->sequence );
		++it;
	}
	delete l;
	return sequence;
}

GWContactInstanceList GWContactList::instancesWithDn( const TQString & dn )
{
	TQObjectList * l = queryList( "GWContactInstance", 0, false, true );
	TQObjectListIt it( *l ); // iterate over the buttons
	TQObject *obj;
	GWContactInstanceList matches;
	while ( (obj = it.current()) != 0 )
	{
		++it;
		GWContactInstance * current = ::tqqt_cast<GWContactInstance *>( obj );
		if ( current->dn == dn )
			matches.append( current );
	}
	delete l;
	return matches;
}

void GWContactList::removeInstance( GWContactListItem * instance )
{
	delete instance;
}

void GWContactList::removeInstanceById( unsigned int id )
{
	TQObjectList * l = queryList( "GWContactInstance", 0, false, true );
	TQObjectListIt it( *l ); // iterate over the buttons
	TQObject *obj;
	GWContactInstanceList matches;
	while ( (obj = it.current()) != 0 )
	{
		++it;
		GWContactInstance * current = ::tqqt_cast<GWContactInstance *>( obj );
		if ( current->id == id )
		{
			delete current;
			break;
		}
	}
	delete l;
}

void GWContactList::dump()
{
	kdDebug(GROUPWISE_DEBUG_GLOBAL) << k_funcinfo << endl;
	const TQObjectList l = childrenListObject();
	if ( !l.isEmpty() )
	{
		TQObjectListIt it( l ); // iterate over the buttons
		TQObject *obj;
		while ( (obj = it.current()) != 0 )
		{
			GWFolder * folder = ::tqqt_cast< GWFolder * >( obj );
			if ( folder )
				folder->dump( 1 );
			++it;
		}
	}
	else
		kdDebug ( GROUPWISE_DEBUG_GLOBAL ) << "  contact list is empty." << endl;
}

void GWContactList::clear()
{
	kdDebug(GROUPWISE_DEBUG_GLOBAL) << k_funcinfo << endl;
	const TQObjectList l = childrenListObject();
	if ( !l.isEmpty() )
	{
		TQObjectListIt it( l );
		TQObject *obj;
		while ( (obj = it.current()) != 0 )
		{
			delete obj;
			++it;
		}
	}
}

GWContactListItem::GWContactListItem( TQObject * parent, unsigned int theId, unsigned int theSequence, const TQString & theDisplayName ) :
	TQObject( parent), id( theId ), sequence( theSequence ), displayName( theDisplayName )
{ }

GWFolder::GWFolder( TQObject * parent, unsigned int theId,  unsigned int theSequence, const TQString & theDisplayName ) :
	GWContactListItem( parent, theId, theSequence, theDisplayName )
{ }

void GWFolder::dump( unsigned int depth )
{
	TQString s;
	s.fill( ' ', ++depth * 2 );
	kdDebug( GROUPWISE_DEBUG_GLOBAL ) << s <<"Folder " << displayName << " id: " << id << " contains: " << endl;
	const TQObjectList l = childrenListObject();
	if ( !l.isEmpty() )
	{
		TQObjectListIt it( l ); // iterate over the buttons
		TQObject *obj;
		while ( (obj = it.current()) != 0 )
		{
			++it;
			GWContactInstance * instance = ::tqqt_cast< GWContactInstance * >( obj );
			if (instance)
				instance->dump( depth );
			else
			{
				GWFolder * folder = ::tqqt_cast< GWFolder * >( obj );
				if ( folder )
					folder->dump( depth );
			}
		}
	}
	else
		kdDebug( GROUPWISE_DEBUG_GLOBAL ) << s << "  no contacts." << endl;
}

GWContactInstance::GWContactInstance( TQObject * parent, unsigned int theId, unsigned int theSequence, const TQString & theDisplayName, const TQString & theDn ) :
	GWContactListItem( parent, theId, theSequence, theDisplayName ), dn( theDn )
{ }

void GWContactInstance::dump( unsigned int depth )
{
	TQString s;
	s.fill( ' ', ++depth * 2 );
	kdDebug( GROUPWISE_DEBUG_GLOBAL ) << s << "Contact " << displayName << " id: " << id << " dn: " << dn << endl;
}
#include "gwcontactlist.moc"

