/*
    Tests for the wallet manager

    Copyright (c) 2003      by Richard Smith          <kde@metafoo.co.uk>
    Kopete    (c) 2002-2003 by the Kopete developers  <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#include <tqtextstream.h>
#include <tqtimer.h>

#include <tdeaboutdata.h>
#include <tdeapplication.h>
#include <tdecmdlineargs.h>
#include <kdebug.h>
#include <tdeglobal.h>
#include <kstandarddirs.h>
#include <dcopclient.h>
#include <tdewallet.h>

#include "kopetewalletmanager.h"
#include "kopetewallettest_program.h"

static TQTextStream _out( stdout, IO_WriteOnly );

void closeWallet()
{
	Kopete::WalletManager::self()->closeWallet();
}

void delay()
{
	TQTimer::singleShot( 3000, tqApp, TQT_SLOT( quit() ) );
	tqApp->exec();
}

void openWalletAsync()
{
	WalletReciever *r = new WalletReciever;
	_out << "[ASYNC] About to open wallet, receiver: " << r << endl;
	Kopete::WalletManager::self()->openWallet( r, TQT_SLOT( gotWallet(  TDEWallet::Wallet* ) ) );
}

void WalletReciever::gotWallet( TDEWallet::Wallet *w )
{
	_out << "[ASYNC] Received wallet pointer: " << w << " for receiver: " << this << endl;
}

void WalletReciever::timer()
{
	_out << "Timer..." << endl;
}

int main( int argc, char *argv[] )
{
	TDEAboutData aboutData( "kopetewallettest", "kopetewallettest", "version" );
	TDECmdLineArgs::init( argc, argv, &aboutData );
	TDECmdLineOptions opts[] = { {"+action",0,0}, TDECmdLineLastOption };
	TDECmdLineArgs::addCmdLineOptions( opts );
	TDEApplication app( "kopetewallettest" );

	TDECmdLineArgs *args = TDECmdLineArgs::parsedArgs();

	// must register with DCOP or async callbacks will fail
	_out << "DCOP registration returned " << app.dcopClient()->registerAs(app.name()) << endl;

	for( int i = 0; i < args->count(); ++i )
	{
		TQString arg = args->arg( i );
		_out << "Processing " << arg << endl;
		if( arg == TQString::fromLatin1( "open" ) ) openWalletAsync();
		if( arg == TQString::fromLatin1( "close" ) ) closeWallet();
		if( arg == TQString::fromLatin1( "delay" ) ) delay();
		_out << "Done." << endl;
	}

	WalletReciever *r = new WalletReciever;

	TQTimer timer;
	r->connect( &timer, TQT_SIGNAL( timeout() ), TQT_SLOT( timer() ) );
	timer.start( 1000 );

	_out << "About to start 30 second event loop" << endl;
	TQTimer::singleShot( 30000, tqApp, TQT_SLOT( quit() ) );
	return tqApp->exec();
}

#include "kopetewallettest_program.moc"
