/*
    kopetetask.cpp - Kopete Task

    Copyright (c) 2004      by Richard Smith         <kde@metafoo.co.uk>
    Kopete    (c) 2002-2004 by the Kopete developers <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This library is free software; you can redistribute it and/or         *
    * modify it under the terms of the GNU Lesser General Public            *
    * License as published by the Free Software Foundation; either          *
    * version 2 of the License, or (at your option) any later version.      *
    *                                                                       *
    *************************************************************************
*/

#include "kopetetask.h"

#include <tdelocale.h>

#include <tqptrlist.h>

namespace Kopete
{

class Task::Private
{
public:
	Private()
	 : result( ResultFailed )
	{
		errorMessage = i18n( "The operation has not finished yet" );
	}

	Task::Result result;
	TQString errorMessage;
	TQPtrList<Task> subtasks;
};

Task::Task()
 : d( new Private )
{
}

Task::~Task()
{
	delete d;
}

bool Task::succeeded() const
{
	return d->result == ResultSucceeded;
}

const TQString &Task::errorString() const
{
	return d->errorMessage;
}

void Task::abort( int flags )
{
	int childFlags = flags & ~AbortEmitResult;
	for ( Task *task = d->subtasks.first(); task; task = d->subtasks.next() )
		task->abort( childFlags );

	if ( flags & AbortEmitResult )
		emitResult( ResultFailed, i18n( "Aborted" ) );
	else
		delete this;
}

void Task::addSubtask( Task *task )
{
	d->subtasks.append( task );
	connect( task, TQT_SIGNAL( result( Kopete::Task* ) ),
	         this, TQT_SLOT( slotResult( Kopete::Task* ) ) );
	connect( task, TQT_SIGNAL( statusMessage( Kopete::Task*, const TQString & ) ),
	         this, TQT_SIGNAL( statusMessage( Kopete::Task*, const TQString & ) ) );
}

void Task::removeSubtask( Task *task, RemoveSubtaskIfLast actionIfLast )
{
	disconnect( task, TQT_SIGNAL( result( Kopete::Task* ) ),
	            this, TQT_SLOT( slotResult( Kopete::Task* ) ) );
	disconnect( task, TQT_SIGNAL( statusMessage( Kopete::Task*, const TQString & ) ),
	            this, TQT_SIGNAL( statusMessage( Kopete::Task*, const TQString & ) ) );
	d->subtasks.remove( task );
	if ( d->subtasks.isEmpty() && actionIfLast == IfLastEmitResult )
		emitResult( task->succeeded() ? ResultSucceeded : ResultFailed, task->errorString() );
}

void Task::emitResult( Result res, const TQString &errorMessage )
{
	d->result = res;
	d->errorMessage = errorMessage;
	emit result( this );
	delete this;
}

void Task::slotResult( Kopete::Task *task )
{
	removeSubtask( task );
}

}

#include "kopetetask.moc"
