/*
 * knewstickerconfig.h
 *
 * Copyright (c) 2000, 2001 Frerich Raabe <raabe@kde.org>
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. For licensing and distribution details, check the
 * accompanying file 'COPYING'.
 */
#ifndef KCMNEWSTICKER_H
#define KCMNEWSTICKER_H

#include "knewstickerconfigwidget.h"
#include "configaccess.h"
#include "newsengine.h"

#include <kdialogbase.h>

#include <tqevent.h>
#include <tqfont.h>
#include <tqlistview.h>

class KNewsTickerConfig;
class KNewsTickerConfigWidget;
class TDEConfig;
class NewsIconMgr;
class ConfigAccess;

class CategoryItem : public TQListViewItem
{
	public:
		CategoryItem(TQListView *, const TQString &);

		void setOpen(bool);
};

class NewsSourceItem : public TQCheckListItem
{
	public:
		NewsSourceItem(KNewsTickerConfig *, CategoryItem *, const NewsSourceBase::Data &);

		NewsSourceBase::Data data() const;
		void setData(const NewsSourceBase::Data &);
		void setIcon(const TQPixmap &);

		TQListViewItem *parentItem() { return TQCheckListItem::parent(); }
	
	private:
		TQString      m_icon;
		bool         m_isProgram;
		NewsSourceBase::Subject m_subject;
		CategoryItem *m_parent;
		KNewsTickerConfig *m_kcm;
};

class KNewsTickerConfig : public KDialogBase
{
	Q_OBJECT
  
	friend class NewsSourceItem;
	public:
		KNewsTickerConfig(ConfigAccess *, TQWidget * = 0, const char * = 0);

		void load();
		void save();
		void defaults();

	protected:
		void addNewsSource(const NewsSourceBase::Data &, bool = false);
		void modifyNewsSource(TQListViewItem *);
		void removeNewsSource();
		void addFilter(const ArticleFilter &);
		void removeFilter(TQListViewItem *);
		void resizeEvent(TQResizeEvent *);
		void openModifyDialog();
		bool eventFilter(TQObject *o, TQEvent *e);
		void getNewsIcon(NewsSourceItem *, const KURL &);

	protected slots:
		void slotNewsSourceContextMenu(TDEListView *, TQListViewItem *, const TQPoint &);
		void slotChooseFont();
		void slotAddNewsSource();
		void slotAddFilter();
		void slotAddNewsSource(const NewsSourceBase::Data &);
		void slotRemoveNewsSource();
		void slotRemoveFilter();
		void slotModifyNewsSource();
		void slotModifyNewsSource(const NewsSourceBase::Data &);
		void slotModifyNewsSource(TQListViewItem *, const TQPoint &, int);
		void slotNewsSourceSelectionChanged();
		void slotFilterSelectionChanged(TQListViewItem *);
		void slotFilterActionChanged(const TQString &);
		void slotFilterNewsSourceChanged(const TQString &);
		void slotFilterConditionChanged(const TQString &);
		void slotFilterExpressionChanged(const TQString &);
		virtual void slotOk();

	private slots:
		void slotGotNewsIcon(const KURL &, const TQPixmap &);

	private:
		ConfigAccess        *m_cfg;
		KNewsTickerConfigWidget *m_child;
		TQFont               m_font;
		NewsSourceItem      *m_modifyItem;
		NewsIconMgr         *m_newsIconMgr;
		TQMap<TQString, NewsSourceItem *> m_itemIconMap;
};

#endif // KCMNEWSTICKER_H
