/*
 * configaccess.h
 *
 * Copyright (c) 2001 Frerich Raabe <raabe@kde.org>
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. For licensing and distribution details, check the
 * accompanying file 'COPYING'.
 */
#ifndef CONFIGACCESS_H
#define CONFIGACCESS_H

#include "configiface.h"
#include "newsengine.h"

#include <tdeconfig.h>
#include <tdeio/job.h>
#include <tdelocale.h>

#include <tqpixmap.h>
#include <tqvaluelist.h>

#define DEFAULT_NEWSSOURCES 43
#define DEFAULT_SUBJECTS 13

class TQColor;
class TQFont;
class KURL;

class ArticleFilter {
	public:
		typedef TQValueList<int> List;

		ArticleFilter(const TQString & = I18N_NOOP(TQString::fromLatin1("Show")),
				const TQString & = I18N_NOOP(TQString::fromLatin1("all newssources")),
				const TQString & = I18N_NOOP(TQString::fromLatin1("contain")),
				const TQString & = TQString(),
				bool = true);

		TQString action() const { return m_action; }
		void setAction(const TQString &action) { m_action = action; }

		TQString newsSource() const { return m_newsSource; }
		void setNewsSource(const TQString &newsSource) { m_newsSource = newsSource; }
		
		TQString condition() const { return m_condition; }
		void setCondition(const TQString &condition) { m_condition = condition; }

		TQString expression() const { return m_expression; }
		void setExpression(const TQString &expression) { m_expression = expression; }

		bool enabled() const { return m_enabled; }
		void setEnabled(bool enabled) { m_enabled = enabled; }

		unsigned int id() const { return m_id; }
		void setId(const unsigned int id) { m_id = id; }

		bool matches(Article::Ptr) const;
	
	private:
		TQString m_action;
		TQString m_newsSource;
		TQString m_condition;
		TQString m_expression;
		bool    m_enabled;
		unsigned int    m_id;
};

class ConfigAccess : public ConfigIface
{
	public:
		ConfigAccess();
		ConfigAccess(TDEConfig *);
		virtual ~ConfigAccess();

		virtual unsigned int interval() const;
		virtual unsigned int scrollingSpeed() const;
		virtual unsigned int mouseWheelSpeed() const;
		virtual unsigned int scrollingDirection() const;
		virtual bool customNames() const;
		virtual bool scrollMostRecentOnly() const;
		virtual bool offlineMode() const;
		virtual bool underlineHighlighted() const;
		virtual bool showIcons() const;
		virtual bool slowedScrolling() const;
		virtual TQColor foregroundColor() const;
		virtual TQColor backgroundColor() const;
		virtual TQColor highlightedColor() const;
		TQFont font() const;
		virtual TQStringList newsSources() const;
		NewsSourceBase *newsSource(const TQString &);
		ArticleFilter::List filters() const;
		ArticleFilter filter(const unsigned int) const;
		
		static bool horizontal(Direction d) { return d == Left || d == Right; }
		static bool vertical(Direction d) { return d == Up || d == Down; }
		static bool rotated(Direction d) { return d == UpRotated || d == DownRotated; }

		inline bool horizontalScrolling() const
		{
			return horizontal((Direction) scrollingDirection());
		};

		inline bool verticalScrolling() const
		{
			return vertical((Direction)scrollingDirection());
		};

		virtual void setInterval(const unsigned int);
		virtual void setScrollingSpeed(const unsigned int);
		virtual void setMouseWheelSpeed(const unsigned int);
		virtual void setScrollingDirection(const unsigned int);
		virtual void setCustomNames(bool);
		virtual void setScrollMostRecentOnly(bool);
		virtual void setOfflineMode(bool);
		virtual void setUnderlineHighlighted(bool);
		virtual void setShowIcons(bool);
		virtual void setSlowedScrolling(bool);
		virtual void setForegroundColor(const TQColor &);
		virtual void setBackgroundColor(const TQColor &);
		virtual void setHighlightedColor(const TQColor &);
		void setFont(const TQFont &);
		virtual void setNewsSources(const TQStringList &);
		void setNewsSource(const NewsSourceBase::Data &);
		void setFilters(const ArticleFilter::List &);
		void setFilter(const ArticleFilter &);
		void reparseConfiguration() { m_cfg->reparseConfiguration(); }
	
	private:
		TDEConfig *m_cfg;
		TDEConfig *m_defaultCfg;
};

#endif // CONFIGACCESS_H
