/* -------------------------------------------------------------

   options.h (part of The KDE Dictionary Client)

   Copyright (C) 2000-2001 Christian Gebauer <gebauer@kde.org>

   This file is distributed under the Artistic License.
   See LICENSE for details.

   -------------------------------------------------------------

   GlobalData      manages all global data of Kdict
   DialgoListBox   a list box which ignores Enter, usefull for dialogs
   OptionsDialog   the "Preferences" dialog

 ------------------------------------------------------------- */

#ifndef _KDICT_OPTIONS_H_
#define _KDICT_OPTIONS_H_

#include <tqlistbox.h>
#include <kdialogbase.h>
#include <tdeglobalsettings.h>

class TQLineEdit;
class TQCheckBox;
class TQComboBox;
class TQRadioButton;

class KColorButton;
class KLineEdit;
class KIntSpinBox;


//********* GlobalData ******************************************

#define COL_CNT 6
#define FNT_CNT 2

class GlobalData
{

public:

  enum ColorIndex   { Ctext=0, Cbackground=1, CheadingsText=2, CheadingsBackground=3, Clinks=4, CvisitedLinks=5  };
  enum FontIndex    { Ftext=0, Fheadings=1 };

  void read();
  void write();

  // colors...
  const TQColor& color(int i)           { return c_olors[i]; }
  const TQString& colorName(int i)      { return c_olorNames[i]; }
  int colorCount() const                    { return COL_CNT; }
  TQColor defaultColor(int i);
  bool useCustomColors;
  TQColor textColor();
  TQColor backgroundColor();
  TQColor headingsTextColor();
  TQColor headingsBackgroundColor();
  TQColor linksColor();
  TQColor visitedLinksColor();

  // fonts...
  const TQFont& font(int i)             { return f_onts[i]; }
  const TQString& fontName(int i)       { return f_ontNames[i]; }
  int fontCount() const                     { return FNT_CNT; }
  TQFont defaultFont(int);
  bool useCustomFonts;
  TQFont textFont();
  TQFont headingsFont();

  TQString encryptStr(const TQString& aStr);

  bool defineClipboard;           // define clipboard content on startup?

  TQSize optSize,setsSize,matchSize;      // window geometry
  bool showMatchList;
  TQValueList<int> splitterSizes;

  TDEGlobalSettings::Completion queryComboCompletionMode;

  TQStringList queryHistory;
  bool saveHistory;               // save query history to disk on exit?
  unsigned int maxHistEntrys, maxBrowseListEntrys, maxDefinitions;
  int headLayout;

  TQString server;                 // network client...
  int port,timeout,pipeSize,idleHold;
  TQString encoding;
  bool authEnabled;
  TQString user, secret;
  TQStringList serverDatabases, databases, strategies;
  TQPtrList<TQStringList> databaseSets;
  unsigned int currentDatabase, currentStrategy;

  TQColor  c_olors[COL_CNT];
  TQString c_olorNames[COL_CNT];
  TQFont   f_onts[FNT_CNT];
  TQString f_ontNames[FNT_CNT];

  TQWidget *topLevel;
};

extern GlobalData *global;


//*********  OptionsDialog  ******************************************


class OptionsDialog : public KDialogBase
{
  Q_OBJECT
  

public:

  OptionsDialog(TQWidget *parent=0, const char *name=0);
  ~OptionsDialog();

  //===================================================================================

  class DialogListBox : public TQListBox {

    public:
      // alwaysIgnore==false: enter is ignored when the widget isn't visible/out of focus
      DialogListBox(bool alwaysIgnore=false, TQWidget * parent=0, const char * name=0);
      ~DialogListBox();

    protected:
      void keyPressEvent( TQKeyEvent *e );

      bool a_lwaysIgnore;
  };

  //===================================================================================

  class ColorListItem : public TQListBoxText {

    public:
      ColorListItem( const TQString &text, const TQColor &color=TQt::black );
      ~ColorListItem();
      const TQColor& color()                     { return mColor; }
      void  setColor( const TQColor &color )     { mColor = color; }

    protected:
      virtual void paint( TQPainter * );
      virtual int height( const TQListBox * ) const;
      virtual int width( const TQListBox * ) const;

    private:
      TQColor mColor;
  };

  //===================================================================================

  class FontListItem : public TQListBoxText {

    public:
      FontListItem( const TQString &name, const TQFont & );
      ~FontListItem();
      const TQFont& font()                     { return f_ont; }
      void setFont( const TQFont &);
    protected:
      virtual void paint( TQPainter * );
      virtual int width( const TQListBox * ) const;

    private:
      TQFont f_ont;
      TQString fontInfo;
  };

  //===================================================================================

signals:

  void optionsChanged();

protected slots:
  void slotApply();
  void slotOk();
  void slotDefault();
  void slotChanged();

  //server
  void slotAuthRequiredToggled( bool );

  //colors
  void slotColCheckBoxToggled(bool b);
  void slotColItemSelected(TQListBoxItem *);   // show color dialog for the entry
  void slotColDefaultBtnClicked();
  void slotColChangeBtnClicked();
  void slotColSelectionChanged();

  //fonts
  void slotFontCheckBoxToggled(bool b);
  void slotFontItemSelected(TQListBoxItem *);  // show font dialog for the entry
  void slotFontDefaultBtnClicked();
  void slotFontChangeBtnClicked();
  void slotFontSelectionChanged();

private:

  TQFrame *serverTab;
  TQLabel *l_user, *l_secret;
  KLineEdit *w_server, *w_user, *w_secret, *w_port;
  TQComboBox *w_encoding;
  TQCheckBox *w_auth;
  KIntSpinBox *w_idleHold,*w_timeout,*w_pipesize;

  TQFrame *appTab;
  DialogListBox *c_List,
                *f_List;
  TQCheckBox *c_olorCB,
            *f_ontCB;
  TQPushButton *c_olDefBtn,
              *c_olChngBtn,
              *f_ntDefBtn,
              *f_ntChngBtn;

  TQFrame *layoutTab;
  TQRadioButton *w_layout[3];

  TQFrame *otherTab;
  TQCheckBox *w_Clipboard, *w_Savehist;
  KIntSpinBox *w_Maxhist, *w_Maxbrowse, *w_MaxDefinitions;
  bool configChanged;
};

#endif
