/***************************************************************************
                          kcmsambaconf.h  -  description
                            -------------------
    begin                : Mon Apr  8 13:35:56 CEST 2002
    copyright            : (C) 2002 by Christian Nitschkowski
    email                : segfault_ii@web.de
    copyright            : (C) 2002-2003 by Jan Sch�fer
    email                : janschaefer@users.sourceforge.net
***************************************************************************/

/******************************************************************************
*                                                                            *
*  This file is part of KSambaPlugin.                                        *
*                                                                            *
*  KSambaPlugin is free software; you can redistribute it and/or modify      *
*  it under the terms of the GNU General Public License as published by      *
*  the Free Software Foundation; either version 2 of the License, or         *
*  (at your option) any later version.                                       *
*                                                                            *
*  KSambaPlugin is distributed in the hope that it will be useful,           *
*  but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*  GNU General Public License for more details.                              *
*                                                                            *
*  You should have received a copy of the GNU General Public License         *
*  along with KSambaPlugin; if not, write to the Free Software                     *
*  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301 USA  *
*                                                                            *
******************************************************************************/

#ifndef KCMSAMBACONF_H_
#define KCMSAMBACONF_H_

#include <tdecmodule.h>
#include <kcminterface.h>
#include <share.h>
#include <tqptrlist.h>
#include <tqlistview.h>


class SambaShare;
class SambaFile;
class TQPixmap;
/**
* A TQListViewItem which holds a SambaShare object
**/
class ShareListViewItem : public TQListViewItem
{
public:
  ShareListViewItem(TQListView * parent, SambaShare* share);

  SambaShare* getShare() const;
  void setShare(SambaShare* share);
  void updateShare();

protected:
  SambaShare* _share;
  TQPixmap createPropertyPixmap();
};


class KJanusWidget;
class TQLineEdit;
class TQCheckBox;
class TQSpinBox;
class DictManager;
class SmbConfConfigWidget;

class KcmSambaConf: public TDECModule
{
  Q_OBJECT
  
  public:
    KcmSambaConf(TQWidget *parent = 0L, const char *name = 0L);
    virtual ~KcmSambaConf();

    void load(const TQString &);
    void save();
    void defaults();
    int buttons();
    TQString quickHelp() const;

    virtual TQString handbookSection() const;

  public slots:
    void configChanged();

    void editShare();
    void addShare();
    void removeShare();

    void editPrinter();
    void addPrinter();
    void removePrinter();

    void editShareDefaults();
    void editPrinterDefaults();


  protected:
    /**
    * The path of the smb.conf file
    **/
    TQString _smbconf;
    SambaFile* _sambaFile;

    DictManager* _dictMngr;

    void init();
    void loadUserTab();
    void saveUserTab();
    bool getSocketBoolValue( const TQString & str, const TQString & name );
    int getSocketIntValue( const TQString & str, const TQString & name );
    TQString socketOptions();
    void setComboIndexToValue(TQComboBox* box, const TQString & value, SambaShare* share);

    void loadBaseSettings(SambaShare*s=0L);
    void loadSecurity(SambaShare* );
    void loadLogging(SambaShare* );
    void loadTuning(SambaShare* );
    void loadDomain(SambaShare* );
    void loadWins(SambaShare* );
    void loadPrinting(SambaShare* );
    void loadFilenames(SambaShare* );
    void loadLocking(SambaShare* );
    void loadCharset(SambaShare*);
    void loadLogon(SambaShare* );
    void loadSocket(SambaShare* );
    void loadSSL(SambaShare* );
    void loadProtocol(SambaShare* );
    void loadWinbind(SambaShare* );
    void loadNetbios(SambaShare* );
    void loadVFS(SambaShare* );
    void loadBrowsing(SambaShare* );
    void loadCommands(SambaShare*);
    void loadMisc(SambaShare* );
    void loadDebug(SambaShare* );
    void loadLDAP(SambaShare*);

    void initAdvancedTab();

    void createSmbConfigWidget();
    
  protected slots:
    void addSambaUserBtnClicked();
    void removeSambaUserBtnClicked();
    void sambaUserPasswordBtnClicked();
    void slotMouseButtonPressed(int,TQListViewItem*,const TQPoint &,int);
    void joinADomainBtnClicked();
    void nullPasswordsEnabled(bool);
    void loadBtnClicked();
    void loadCanceled(const TQString & msg);
    void fillFields(); 
    void slotSpecifySmbConf(const TQString &);
    
  private:
    KcmInterface* _interface;
    KJanusWidget* _janus;
    SmbConfConfigWidget* m_smbConfConfigWidget;
};

#endif
