#ifndef VIEW_H
#define VIEW_H

#include <tqevent.h>
#include <tqptrlist.h>
#include <tdelistview.h>
#include <tdemainwindow.h>
#include <tqrect.h>
#include <tqdict.h>
#include <tdeio/global.h>
#include <noatun/downloader.h>

class Finder;
class View;
namespace TDEIO { class ListJob; }


class SafeListViewItem
	: public TQCheckListItem
	, public PlaylistItemData
	, public DownloadItem
{
public:
	SafeListViewItem(TQListView *parent, TQListViewItem *after, const KURL &text);
	SafeListViewItem(TQListView *parent, TQListViewItem *after, const TQMap<TQString,TQString> &properties);
	virtual ~SafeListViewItem();

	virtual TQString property(const TQString &, const TQString & = 0) const;
	virtual void setProperty(const TQString &, const TQString &);
	virtual void clearProperty(const TQString &);
	virtual TQStringList properties() const;
	virtual bool isProperty(const TQString &) const;

	virtual TQString file() const;

	int compare(TQListViewItem * i, int col, bool ascending) const;
	virtual void remove();

protected:
	virtual void downloaded(int percent);
	virtual void downloadTimeout();
	virtual void downloadFinished();
	virtual void modified();
	virtual void stateChange(bool s);

	void paintCell(TQPainter *p, const TQColorGroup &cg, int column, int width, int align);

private:
	struct Property
	{
		TQString key;
		TQString value;
	};
	TQValueList<Property> mProperties;
	bool removed;
};

class List : public TDEListView
{
TQ_OBJECT
  
friend class View;
public:
	List(View *parent);
	virtual ~List();
	TQListViewItem *openGlobal(const KURL&, TQListViewItem * =0);
	TQListViewItem *importGlobal(const KURL&, TQListViewItem * =0);
	TQListViewItem *addFile(const KURL&, bool play=false, TQListViewItem * =0);
	void addDirectoryRecursive(const KURL &dir, TQListViewItem *after= 0);

public slots:
	virtual void clear();

signals:
	void modified(void);
	void deleteCurrentItem();

protected:
	virtual bool acceptDrag(TQDropEvent *event) const;
	virtual void keyPressEvent(TQKeyEvent *e);

protected slots:
	virtual void dropEvent(TQDropEvent *event, TQListViewItem *after);
	void move();

protected:
	TQListViewItem *recursiveAddAfter;

protected slots:
	// used when adding directories via TDEIO::listRecursive
	void slotResult(TDEIO::Job *job);
	void slotEntries(TDEIO::Job *job, const TDEIO::UDSEntryList &entries);
	void slotRedirection(TDEIO::Job *, const KURL & url);

protected:
	void addNextPendingDirectory();
	KURL::List pendingAddDirectories;
	TDEIO::ListJob *listJob;
	KURL currentJobURL;
};

class KFileDialog;
class TDEToggleAction;
class TDEToolBar;

class View : public TDEMainWindow
{
TQ_OBJECT
  
public:
	View(SplitPlaylist *mother);
	// load the SM playlist
	void init();
	virtual ~View();
	List *listView() const { return list; }
	TQListViewItem *addFile(const KURL &u, bool play=false)
		{ return list->addFile(u, play, list->lastItem()); }


public slots:
	void deleteSelected();
	void addFiles();
	void addDirectory();
	void save();
	void saveAs();
	void open();
	void openNew();
	void setSorting(bool on, int column = 0);
	void setNoSorting() { setSorting(false); }
	void headerClicked(int column);void find();
	void findIt(Finder *);


private slots:
	void setModified();
	void saveState();

	void configureToolBars();
	void newToolBarConfig();

protected:
	void setupActions();

	bool saveToURL(const KURL &);
	void exportTo(const KURL &);

	void setModified(bool);
	virtual void closeEvent(TQCloseEvent*e);
	virtual void showEvent(TQShowEvent *);
	virtual void hideEvent(TQHideEvent *);

signals:
	void hidden();
	void shown();

private:
	List *list;
	TDEAction *mOpen, *mDelete, *mSave, *mSaveAs, *mOpenpl, *mOpenNew;
	TDEAction *mClose;
	TDEAction *mFind;
	Finder *mFinder;

	KURL mPlaylistFile;
	bool modified;
};

#endif
