/***************************************************************************
                              kclientdialog.cpp
                             -------------------
    Developers: (c) 2000-2001 Nikolas Zimmermann <wildfox@kde.org>
                (c) 2000-2001 Daniel Molkentin <molkentin@kde.org>

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tqstring.h>
#include <tqglobal.h>
#include <kdebug.h>
#include <tdelocale.h>
#include <kcombobox.h>
#include <kuser.h>
#include <tqlayout.h>
#include "kbattleshipserver.h" // for BATTLESHIP_SERVICE
#include "kclientdialog.moc"

KClientDialog::KClientDialog(TQWidget *parent, const char *name) 
 : KDialogBase(Plain, i18n("Connect to Server"), Ok|Cancel, Ok, parent, name, true, false, KGuiItem(i18n("&Connect")))
{
	TQFrame* page = plainPage();
	TQGridLayout* pageLayout = new TQGridLayout(page, 1, 1, 0, 0);
	m_mainWidget = new clientConnectDlg(page);
	pageLayout->addWidget(m_mainWidget, 0, 0);

	enableButtonOK(false);
	m_config = kapp->config();
	KUser u;
	m_mainWidget->nicknameEdit->setText(u.loginName());

	connect(m_mainWidget->serverEdit, TQ_SIGNAL(returnPressed(const TQString &)), this, TQ_SLOT(slotReturnPressed(const TQString &)));
	connect(m_mainWidget->serverEdit, TQ_SIGNAL(textChanged(const TQString &)), this, TQ_SLOT(slotCheckEnableOk()));
	
	m_config->setGroup("History");
	m_browser = new DNSSD::ServiceBrowser(TQString::fromLatin1(BATTLESHIP_SERVICE));
	connect(m_browser,TQ_SIGNAL(finished()),TQ_SLOT(nextBatch()));
	m_browser->startBrowse();
	connect(m_mainWidget->lanBox,TQ_SIGNAL(activated(int)),TQ_SLOT(gameSelected(int)));
	m_mainWidget->serverEdit->completionObject()->setItems(m_config->readListEntry("CompletionList")); 

	m_mainWidget->serverEdit->setMaxCount(5);
	m_mainWidget->serverEdit->setHistoryItems(m_config->readListEntry("HistoryList"));

	m_mainWidget->serverEdit->setCurrentItem(m_config->readNumEntry("Index", -1));
}

KClientDialog::~KClientDialog()
{
	m_config->setGroup("History");
	m_config->writeEntry("CompletionList", m_mainWidget->serverEdit->completionObject()->items());
	m_config->writeEntry("HistoryList", m_mainWidget->serverEdit->historyItems());
	m_config->writeEntry("Index", m_mainWidget->serverEdit->currentItem());
	m_config->sync();
}

void KClientDialog::slotCheckEnableOk()
{
	enableButtonOK(!m_mainWidget->serverEdit->currentText().stripWhiteSpace().isEmpty());
}

void KClientDialog::slotOk()
{
	TQString server = m_mainWidget->serverEdit->currentText().stripWhiteSpace();
	if(!server.isEmpty())
	{
		hide();
		m_mainWidget->serverEdit->addToHistory(server);
		emit sigConnectServer();
	}
	else
		m_mainWidget->serverEdit->clearEdit();
}

void KClientDialog::slotReturnPressed(const TQString &hostname)
{
	if(!hostname.stripWhiteSpace().isEmpty())
		m_mainWidget->serverEdit->addToHistory(hostname);
	else
		m_mainWidget->serverEdit->clearEdit();
}

void KClientDialog::slotCancel()
{
	hide();
	emit sigCancelConnect();
}

TQString KClientDialog::port() const
{
	return TQString::number(m_mainWidget->portEdit->value());
}

TQString KClientDialog::host() const
{
	return m_mainWidget->serverEdit->currentText();
}

TQString KClientDialog::nickname() const
{
	return m_mainWidget->nicknameEdit->text();
}

void KClientDialog::nextBatch() 
{
	bool autoselect=false;
	if (!m_mainWidget->lanBox->count()) autoselect=true;
	m_mainWidget->lanBox->clear();
	TQStringList names;
	TQValueList<DNSSD::RemoteService::Ptr>::ConstIterator itEnd = m_browser->services().end();
	for (TQValueList<DNSSD::RemoteService::Ptr>::ConstIterator it = m_browser->services().begin();
		it!=itEnd; ++it) names << (*it)->serviceName();
	m_mainWidget->lanBox->insertStringList(names);
	if (autoselect && m_mainWidget->lanBox->count()) gameSelected(0);
}

void KClientDialog::gameSelected(int i) 
{
	Q_ASSERT(i < m_browser->services().count()); if( i >= m_browser->services().count()) { slotCheckEnableOk(); return; }
	
	DNSSD::RemoteService::Ptr srv = m_browser->services()[i];
	
	Q_ASSERT(srv); if(!srv) { slotCheckEnableOk(); return; }
	
	if (!srv->isResolved() && !srv->resolve()) return;
	m_mainWidget->serverEdit->setCurrentItem(srv->hostName(),true);
	m_mainWidget->portEdit->setValue(srv->port());
	slotCheckEnableOk();
}


