/***************************************************************************
                          kquestion.cpp  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Javier Campos Morales
    email                : javi@asyris.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "kquestion.h"
#include "kquestion.moc"

#include <tqlayout.h>
#include <tqpixmap.h>
#include <tqvbox.h>
#include <tqtimer.h>

#include <kprogress.h>
#include <tdelocale.h>

KQuestion::KQuestion( TQWidget *parent, const char *name )
  : TQHBox( parent, name ), _countdownTimer( 0 )
{
  initGUI();
}

KQuestion::~KQuestion()
{
}

/** Init graphical interface */
void KQuestion::initGUI()
{
  setFrameShape( TQFrame::Box );
  setFrameShadow( TQFrame::Plain );
  setPalette( TQPalette( TQt::white ) );

  TQVBox *picBox = new TQVBox( this );

  _picture = new TQLabel( picBox, "PixmapLabel1" );
  _picture->setScaledContents( false );
  _picture->setPalette( TQPalette( TQt::white ) );

  _countdownWidget = new KProgress( picBox );
  _countdownWidget->setSizePolicy( TQSizePolicy( TQSizePolicy::Preferred,
                                                TQSizePolicy::Preferred ) );
  _countdownWidget->setFormat( i18n( "%v seconds left" ) );

    _view = new TQTextEdit( this, "TextView1" );
    _view->setReadOnly( true );
    _view->setFrameShape( TQTextEdit::NoFrame );
    _view->setHScrollBarMode( TQTextEdit::AlwaysOff );
    _view->setTextFormat( TQTextEdit::RichText );
    _view->setSizePolicy( TQSizePolicy( (TQSizePolicy::SizeType)7, (TQSizePolicy::SizeType)7, true ) );
}

/** Set text */
void KQuestion::setText( const TQString &text)
{
    _view->setText( text );
}

/** Set pixmap */
void KQuestion::setPixmap( const TQPixmap pixmap)
{
    _picture->setPixmap( pixmap );
}

void KQuestion::countdown(int starttime)
{
  _totalCount = starttime;
  _currentCount = starttime;
  if (starttime > 0)
  {
    if (!_countdownTimer)
    {
      _countdownTimer = new TQTimer(this);
      connect(_countdownTimer, TQ_SIGNAL(timeout()),
              this, TQ_SLOT(countDownOne()));
    }
    _countdownTimer->start(1000);
    // make one step less than time passes by in seconds
    // so that the user will see when time is up
    _countdownWidget->setTotalSteps(starttime);
    _countdownWidget->setProgress(starttime);
  }else{
    _countdownTimer->stop();
    _countdownWidget->reset();
  }
}

void KQuestion::countDownOne()
{
  _currentCount--;
  //_countdownWidget->setProgress(_totalCount - _currentCount);
  _countdownWidget->advance(-1);

  if (_currentCount == 0)
    _countdownTimer->stop();
}

void KQuestion::countdownVisible(bool visible)
{
  if (visible)
    _countdownWidget->show();
  else
    _countdownWidget->hide();
}

/** Get current time */
int KQuestion::getCurrentTime()
{
  return _totalCount - _currentCount;
}
