#!/usr/bin/env python

# This is an example of how to use DCOP Signals with
# the dcoppython KDE bindings.

# something goes wrong if you don't import pcop first.
# Have to do this till I find out why...
import pcop
import pydcop

class MyObject(pydcop.DCOPServerObject):
    """DCOP server object"""

    def __init__(self, id='pythontest'):
        pydcop.DCOPServerObject.__init__(self, id)

        # DCOP needs types, so we need to initialise the object with the methods that
        # it's going to provide.
        self.setMethods( [('void test(TQString)', self.test)])

    def test(self, data):
        print("New Weather for " + data)

appid = pydcop.registerAs('dcopSignalTest')
print("Server: %s starting" % appid)

pytest = MyObject()

sender = "KWeatherService"
senderObj = "WeatherService"
signal = "fileUpdate(TQString)"
receiverObj = "pythontest"
slot = "test(TQString)"
volatile = 1

pydcop.connectDCOPSignal(sender,senderObj,signal,receiverObj,slot,volatile)
# Enter event loop
while 1:
    pydcop.processEvents()


