/***************************************************************************
 *   Copyright (C) 2004 by Mario Bensi                                     *
 *   nef@ipsquad.net                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/
 
#include "addslaves.h"
#include "addalternatives.h"

#include <tdelocale.h>
#include <kstdguiitem.h>
#include <kurlrequester.h>

#include <iostream>
using namespace std;

AddSlaves::AddSlaves(AddAlternatives *addAlternatives):
AddSlavesUi(addAlternatives), m_addAlternatives(addAlternatives)
{
	m_bOk->setGuiItem(KStdGuiItem::ok());
	m_bCancel->setGuiItem(KStdGuiItem::cancel());
	
	m_Path->setCaption( i18n( "Choose Slave" ) );
	m_Path->setFilter( i18n( "*|All Files" ) );
	m_Path->setMode( KFile::File | KFile::LocalOnly );
}

AddSlaves::~AddSlaves()
{
}

void AddSlaves::slotOkClicked()
{
	if(!m_Path->url().isEmpty())
	{
		m_addAlternatives->addSlave(m_Path->url());
		close();
	}
}

#include "addslaves.moc"
