/***************************************************************************
    smb4ksynchronizationdialog  -  The synchronization dialog of Smb4K
                             -------------------
    begin                : Sa Mai 19 2007
    copyright            : (C) 2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KSYNCHRONIZATIONDIALOG_H
#define SMB4KSYNCHRONIZATIONDIALOG_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// KDE includes
#include <tdemacros.h>
#include <kdialogbase.h>
#include <kurlrequester.h>

// forward declarations
class Smb4KShare;
class Smb4KSynchronizationInfo;

/**
 * This class provides a synchronization dialog. It contains URL requesters
 * for the source and destination as well as widgets to monitor the process
 * of the synchronization.
 *
 * @author Alexander Reinholdt <dustpuppy@users.berlios.de>
 */

class TDE_EXPORT Smb4KSynchronizationDialog : public KDialogBase
{
  TQ_OBJECT
  

  public:
    /**
     * The constructor
     *
     * @param share         The share item
     *
     * @param parent        The parent widget
     *
     * @param name          The name of this dialog
     */
    Smb4KSynchronizationDialog( Smb4KShare *share, TQWidget *parent = 0, const char *name = 0 );

    /**
     * The destructor
     */
    ~Smb4KSynchronizationDialog();

  protected slots:
    /**
     * Reimplemented from KDialogBase. This slot starts the
     * synchronization.
     */
    void slotUser1();

    /**
     * Reimplemented from KDialogBase. This slot swaps the
     * paths of the source and destination.
     */
    void slotUser2();

    /**
     * Reimplemented from KDialogBase. This slot aborts the
     * current synchronization and exists the dialog.
     */
    void slotCancel();

    /**
     * This slot receives information about the progress of the
     * current synchronization and puts it into the dialog.
     *
     * @param info          Information about the progress of the
     * current synchronization process.
     */
    void slotProgress( const Smb4KSynchronizationInfo &info );

    /**
     * This slot is invoked when the synchronization has finished.
     * It is connected to the Smb4KSynchronizer::finished() signal.
     */
    void slotSynchronizationFinished();

  private:
    /**
     * A pointer to the share object
     */
    Smb4KShare *m_share;
};

#endif
