/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _RG_TEMPODIALOG_H_
#define _RG_TEMPODIALOG_H_

#include <kdialogbase.h>
#include "base/Event.h"
#include "base/Composition.h"
#include <tqpushbutton.h>
#include <tqdatetime.h>


class TQWidget;
class TQString;
class TQRadioButton;
class TQLabel;
class TQCheckBox;


namespace Rosegarden
{

class TimeWidget;
class RosegardenGUIDoc;
class HSpinBox;


class TempoDialog : public KDialogBase
{
    TQ_OBJECT
  
public:
    enum TempoDialogAction {
        AddTempo,
        ReplaceTempo,
        AddTempoAtBarStart,
        GlobalTempo,
        GlobalTempoWithDefault
    };

    TempoDialog(TQWidget *parent, RosegardenGUIDoc *doc,
                bool timeEditable = false);
    ~TempoDialog();

    // Set the position at which we're checking the tempo
    //
    void setTempoPosition(timeT time);

public slots:
    virtual void slotOk();
    void slotActionChanged();
    void slotTempoChanged(const TQString &);
    void slotTempoConstantClicked();
    void slotTempoRampToNextClicked();
    void slotTempoRampToTargetClicked();
    void slotTargetChanged(const TQString &);
    void slotTapClicked();

signals:
    // Return results in this signal
    //
    void changeTempo(timeT,  // tempo change time
                     tempoT,  // tempo value
                     tempoT,  // target tempo value
                     TempoDialog::TempoDialogAction); // tempo action

protected:
    void populateTempo();
    void updateBeatLabels(double newTempo);

    //--------------- Data members ---------------------------------

    RosegardenGUIDoc     *m_doc;
    timeT                 m_tempoTime;
    HSpinBox             *m_tempoValueSpinBox;
    TQPushButton          *m_tempoTap;
    TQTime                 m_tapMinusTwo;
    TQTime                 m_tapMinusOne;

    TQRadioButton         *m_tempoConstant;
    TQRadioButton         *m_tempoRampToNext;
    TQRadioButton         *m_tempoRampToTarget;
    HSpinBox             *m_tempoTargetSpinBox; 

    TQLabel               *m_tempoBeatLabel;
    TQLabel               *m_tempoBeat;
    TQLabel               *m_tempoBeatsPerMinute;

    TimeWidget           *m_timeEditor;

    TQLabel               *m_tempoTimeLabel;
    TQLabel               *m_tempoBarLabel;
    TQLabel               *m_tempoStatusLabel;
    
    TQRadioButton         *m_tempoChangeHere;
    TQRadioButton         *m_tempoChangeBefore;
    TQLabel               *m_tempoChangeBeforeAt;
    TQRadioButton         *m_tempoChangeStartOfBar;
    TQRadioButton         *m_tempoChangeGlobal;
    TQCheckBox            *m_defaultBox;
};


}

#endif
