/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.
 
    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>
 
    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.
 
    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.
 
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/


#include "BasicSelectionCommand.h"

#include "base/Segment.h"
#include "base/Selection.h"
#include "BasicCommand.h"
#include <tqstring.h>


namespace Rosegarden
{
    
BasicSelectionCommand::BasicSelectionCommand(const TQString &name,
                         EventSelection &selection,
                         bool bruteForceRedo) :
    BasicCommand(name,
         selection.getSegment(),
         selection.getStartTime(),
         selection.getEndTime(),
         bruteForceRedo)
{
    // nothing
}

BasicSelectionCommand::BasicSelectionCommand(const TQString &name,
                         Segment &segment,
                         bool bruteForceRedo) :
    BasicCommand(name,
         segment,
         segment.getStartTime(),
         segment.getEndMarkerTime(),
         bruteForceRedo)
{
    // nothing
}

BasicSelectionCommand::~BasicSelectionCommand()
{
    // nothing
}
    
}
