/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.
 
    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>
 
    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.
 
    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.
 
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/


#include "NoteFontViewer.h"

#include <tdelocale.h>
#include "FontViewFrame.h"
#include <kcombobox.h>
#include <kdialogbase.h>
#include <tdetoolbar.h>
#include <tqlabel.h>
#include <tqstring.h>
#include <tqstringlist.h>
#include <tqvbox.h>
#include <tqwidget.h>


namespace Rosegarden
{

void
NoteFontViewer::slotViewChanged(int i)
{
    m_frame->setGlyphs(i == 0);

    m_rows->clear();
    int firstRow = -1;

    for (int r = 0; r < 256; ++r) {
        if (m_frame->hasRow(r)) {
            m_rows->insertItem(TQString("%1").arg(r));
            if (firstRow < 0)
                firstRow = r;
        }
    }

    if (firstRow < 0) {
        m_rows->setEnabled(false);
        m_frame->setRow(0);
    } else {
        m_rows->setEnabled(true);
        m_frame->setRow(firstRow);
    }
}

void
NoteFontViewer::slotRowChanged(const TQString &s)
{
    bool ok;
    int i = s.toInt(&ok);
    if (ok)
        m_frame->setRow(i);
}

void
NoteFontViewer::slotFontChanged(const TQString &s)
{
    m_frame->setFont(s);
    slotViewChanged(m_view->currentItem());
}

NoteFontViewer::NoteFontViewer(TQWidget *parent, TQString noteFontName,
                               TQStringList fontNames, int pixelSize) :
        KDialogBase(parent, 0, true,
                    i18n("Note Font Viewer: %1").arg(noteFontName), Close)
{
    TQVBox *box = makeVBoxMainWidget();
    TDEToolBar* controls = new TDEToolBar(box);
    controls->setMargin(3);

    (void) new TQLabel(i18n("  Component: "), controls);
    m_font = new KComboBox(controls);

    for (TQStringList::iterator i = fontNames.begin(); i != fontNames.end();
            ++i) {
        m_font->insertItem(*i);
    }

    (void) new TQLabel(i18n("  View: "), controls);
    m_view = new KComboBox(controls);

    m_view->insertItem(i18n("Glyphs"));
    m_view->insertItem(i18n("Codes"));

    (void) new TQLabel(i18n("  Page: "), controls);
    m_rows = new KComboBox(controls);

    m_frame = new FontViewFrame(pixelSize, box);

    connect(m_font, TQT_SIGNAL(activated(const TQString &)),
            this, TQT_SLOT(slotFontChanged(const TQString &)));

    connect(m_view, TQT_SIGNAL(activated(int)),
            this, TQT_SLOT(slotViewChanged(int)));

    connect(m_rows, TQT_SIGNAL(activated(const TQString &)),
            this, TQT_SLOT(slotRowChanged(const TQString &)));

    slotFontChanged(m_font->currentText());
}

}
#include "NoteFontViewer.moc"
