/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.
 
    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>
 
    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.
 
    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.
 
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/


#include "SplitByRecordingSrcDialog.h"
#include <tqlayout.h>

#include <tdelocale.h>
#include "misc/Strings.h"
#include "base/MidiDevice.h"
#include "document/RosegardenGUIDoc.h"
#include <kcombobox.h>
#include <kdialogbase.h>
#include <tqframe.h>
#include <tqgroupbox.h>
#include <tqlabel.h>
#include <tqsizepolicy.h>
#include <tqstring.h>
#include <tqvbox.h>
#include <tqwidget.h>


namespace Rosegarden
{

SplitByRecordingSrcDialog::SplitByRecordingSrcDialog(TQWidget *parent, RosegardenGUIDoc *doc) :
        KDialogBase(parent, 0, true, i18n("Split by Recording Source"), Ok | Cancel )
{
    TQVBox *vBox = makeVBoxMainWidget();

    TQGroupBox *groupBox = new TQGroupBox
                          (1, Qt::Horizontal, i18n("Recording Source"), vBox);
    TQFrame *frame = new TQFrame(groupBox);
    TQGridLayout *layout = new TQGridLayout(frame, 2, 2, 10, 5);

    layout->addWidget(new TQLabel( i18n("Channel:"), frame ), 0, 0);
    m_channel = new KComboBox( frame );
    m_channel->setSizeLimit( 17 );
    layout->addWidget(m_channel, 0, 1);
    TQSpacerItem *spacer = new TQSpacerItem( 1, 1, TQSizePolicy::Expanding, TQSizePolicy::Minimum );
    layout->addItem( spacer, 0, 2 );

    m_channel->insertItem(i18n("any"));
    for (int i = 1; i < 17; ++i) {
        m_channel->insertItem(TQString::number(i));
    }

    layout->addWidget(new TQLabel( i18n("Device:"), frame ), 1, 0);
    m_device = new KComboBox( frame );
    layout->addMultiCellWidget( m_device, 1, 1, 1, 2 );

    m_deviceIds.clear();
    m_deviceIds.push_back( -1);
    m_device->insertItem(i18n("any"));

    DeviceList *devices = doc->getStudio().getDevices();
    DeviceListConstIterator it;
    for (it = devices->begin(); it != devices->end(); it++) {
        MidiDevice *dev =
            dynamic_cast<MidiDevice*>(*it);
        if (dev && dev->getDirection() == MidiDevice::Record) {
            TQString label = TQString::number(dev->getId());
            label += ": ";
            label += strtoqstr(dev->getName());
            TQString connection = strtoqstr(dev->getConnection());
            label += " - ";
            if (connection == "")
                label += i18n("No connection");
            else
                label += connection;
            m_device->insertItem(label);
            m_deviceIds.push_back(dev->getId());
        }
    }

    m_channel->setCurrentItem(0);
    m_device->setCurrentItem(0);
}

int
SplitByRecordingSrcDialog::getChannel()
{
    return m_channel->currentItem() - 1;
}

int
SplitByRecordingSrcDialog::getDevice()
{
    return m_deviceIds[m_device->currentItem()];
}

}
#include "SplitByRecordingSrcDialog.moc"
