
iconName = 'icons'
labelText = 'Icon Sizing'


from PyTQt.tqt import TQFrame, TQHBoxLayout, TQVBoxLayout, TQ_SIGNAL
from tdecore import i18n
from tdeui import TDEAboutDialog, KPushButton, KBugReport, KTextEdit


helpText = ("")


class MainFrame(TQFrame):
    def __init__(self, parent=None):
        TQFrame.__init__(self, parent)
        self.button = KPushButton(i18n('Show Bug Report Dialog'), self)
        self.help = KTextEdit(helpText, '', self)
        layout = TQVBoxLayout(self, 4)
        layout.addWidget(self.help)
        buttonlayout = TQHBoxLayout(layout, 4)
        buttonlayout.addWidget(self.button)
        buttonlayout.addStretch(1)
        layout.addStretch(1)
        self.connect(self.button, TQ_SIGNAL('clicked()'), self.showBugDialog)


    def showBugDialog(self):
        dlg = KBugReport(self)
        dlg.exec_loop()
