/***************************************************************************
 *   Copyright (C) 2004 by Antonio Fasolato                                *
 *   Antonio.Fasolato@poste.it                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include "potracegui.h"

#include <tdeapplication.h>
#include <tdeaboutdata.h>
#include <tdecmdlineargs.h>
#include <tdelocale.h>

static const char description[] =
    I18N_NOOP("An interface for potrace and autotrace");

static TDECmdLineOptions options[] =
{
   { "+[URL]", I18N_NOOP( "Document to open" ), 0 },
    TDECmdLineLastOption
};

int main(int argc, char **argv)
{
    TDEAboutData about("potracegui", I18N_NOOP("potracegui"), "1.3", description,
                     TDEAboutData::License_GPL, "(C) 2004 Antonio Fasolato", 0, 0, "Antonio.Fasolato@poste.it");
    about.addAuthor( "Antonio Fasolato", 0, "Antonio.Fasolato@poste.it" );
	 about.addCredit( "Tim Fechtner", I18N_NOOP("German translation"), "Tim.Fechtner@gmx.de");
    TDECmdLineArgs::init(argc, argv, &about);
    TDECmdLineArgs::addCmdLineOptions( options );
    TDEApplication app;
    potracegui *firstWidget = 0;
	 
	TDECmdLineArgs *args = TDECmdLineArgs::parsedArgs();

	firstWidget = new potracegui();
	firstWidget->show();

	args->clear();

   return app.exec();
}

