/***************************************************************************
 *   Copyright (C) 2004 by Antonio Fasolato                                *
 *   Antonio.Fasolato@poste.it                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#include "autotraceformats.h"

AutotraceFormats::AutotraceFormats(TQObject *parent, const char *name): TQObject(parent, name), allOK(true) {
	inputProcess=new TQProcess(this);
	outputProcess=new TQProcess(this);

	inputProcess->addArgument("autotrace");
	inputProcess->addArgument("--list-input-formats");
	
	outputProcess->addArgument("autotrace");
	outputProcess->addArgument("--list-output-formats");
	
	connect(inputProcess,TQ_SIGNAL(readyReadStderr()),this,TQ_SLOT(inputRead()));
	connect(outputProcess,TQ_SIGNAL(readyReadStderr()),this,TQ_SLOT(outputRead()));
	
	if(!(inputProcess->start()) || !(outputProcess->start())) {
		allOK=false;
	}
}

void AutotraceFormats::inputRead( ) {
	while(inputProcess->canReadLineStderr()) {
		input+=inputProcess->readLineStderr();
	}
}

void AutotraceFormats::outputRead( ) {
	while(outputProcess->canReadLineStderr()) {
		TQString tmp=outputProcess->readLineStderr();
		if(!(tmp.startsWith("Supported")))
			output+=tmp.stripWhiteSpace();
	}
}

bool AutotraceFormats::OK( ) {
	return allOK;
}

bool AutotraceFormats::done( ) {
	return (!(inputProcess->isRunning()) && !(outputProcess->isRunning()));
}

TQStringList AutotraceFormats::inputFormats( ) {
	return input;
}

TQStringList AutotraceFormats::outputFormats( ) {
	return output;
}


#include "autotraceformats.moc"
