/***************************************************************************
 *   Copyright (C) 2005-2007 Nicolas Hadacek <hadacek@kde.org>             *
 *   Copyright (C) 2003-2004 Alain Gibaud <alain.gibaud@free.fr>           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef HARDWARE_CONFIG_WIDGET
#define HARDWARE_CONFIG_WIDGET

#include <tqlineedit.h>
#include <tqcombobox.h>
#include <kdialogbase.h>
#include <ktextbrowser.h>

#include "progs/base/hardware_config.h"
#include "progs/gui/prog_config_widget.h"
#include "progs/base/generic_prog.h"
#include "progs/base/prog_specific.h"

namespace Hardware
{

//-----------------------------------------------------------------------------
class HConfigWidget : public TQFrame
{
TQ_OBJECT
  
public:
  HConfigWidget(::Programmer::Base &base, TQWidget *parent, bool edit);
  virtual ~HConfigWidget() { delete _hardware; }
  virtual bool set(const Port::Description &pd, const Data &data) = 0;
  virtual Data *data() const = 0;
  Port::Description portDescription() const { return _hardware->portDescription(); }

protected:
  ::Programmer::Hardware *_hardware;
  TQVBoxLayout *_mainVBox, *_editVBox;
  bool _edit, _connected;
  ::Programmer::Base &_base;
};

//-----------------------------------------------------------------------------
class ConfigWidget;

class EditDialog : public KDialogBase
{
TQ_OBJECT
  
public:
  EditDialog(ConfigWidget *parent, const TQString &name, const Port::Description &pd, Data *data);
  TQString savedName() const { return _savedName; }

private slots:
  virtual void slotOk();
  virtual void slotCancel();

private:
  ConfigWidget  *_cwidget;
  TQString        _savedName;
  Data          *_oldData;
  HConfigWidget *_hc;
  TQLineEdit     *_name;
};

//-----------------------------------------------------------------------------
class ConfigWidget : public ::Programmer::ConfigWidget
{
TQ_OBJECT
  
public:
  ConfigWidget(::Programmer::Base *base, Config *config, TQWidget *parent);
  virtual ~ConfigWidget() { delete _base; }
  virtual void saveConfig();
  virtual bool setPort(const ::Programmer::HardwareDescription &hd);
  virtual HConfigWidget *createHardwareConfigWidget(TQWidget *parent, bool edit) const = 0;

private slots:
  void editClicked();
  void deleteClicked();
  void configChanged(int i);

protected:
  ::Programmer::Base *_base;

private:
  Config        *_config;
  TQStringList    _names;
  HConfigWidget *_hc;
  TQPushButton   *_editButton, *_deleteButton;
  TQComboBox     *_configCombo;
  KTextBrowser  *_comment;
  TQHBoxLayout   *_hbox;

  void updateList(PortType type);
  bool set(const Port::Description &pd, uint i);

  friend class EditDialog;
};

} // namespace

#endif
