//
// C++ Implementation: showheaderdialog
//
// Description:
//
//
// Author: Ulrich Weigelt <ulrich.weigelt@gmx.de>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "showheaderdialog.h"

ShowHeaderDialog::ShowHeaderDialog( TQWidget * parent, TQString & caption, TQString & subject, TQString header ) :
    KDialogBase( parent, "showheaderdialog", true, caption, KDialogBase::Ok | KDialogBase::Cancel, KDialogBase::Ok, true )
{
  //create main widget
  TQWidget* mainWidget = new TQWidget( this );
  setMainWidget( mainWidget );

  //this layout seperates meta data area (subject) from the mail header area
  TQVBoxLayout* layMain = new TQVBoxLayout( mainWidget, 0, spacingHint() );

  //this layout arranges the labels and lines for the meta datas
  TQHBoxLayout* layMetaDatas = new TQHBoxLayout( layMain, spacingHint() );

  //create label for subject
  TQLabel* lblSubject = new TQLabel( i18n( "Subject:" ), mainWidget, "lblSubject" );
  layMetaDatas->addWidget( lblSubject );

  //create line edit for subject
  KLineEdit* liSubject = new KLineEdit( subject, mainWidget, "liSubject" );
  liSubject->setReadOnly( true );
  layMetaDatas->addWidget( liSubject );

  //create text edit for the header
  KTextEdit* txtHeader = new KTextEdit( mainWidget );

  txtHeader->setText( header );
  txtHeader->setMinimumSize( WIDTH_VIEW_MAILHEADER, HEIGHT_VIEW_MAILHEADER );

  layMain->addWidget( txtHeader );
}



ShowHeaderDialog::~ShowHeaderDialog()
{
}


#include "showheaderdialog.moc"
