/***************************************************************************
                          ksensorscfg.cpp  -  description
                             -------------------
    begin                : mi may 8 2002
    copyright            : (C) 2002 by Miguel Novas
    email                : michaell@teleline.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ksensorscfg.h"

#include <tqvariant.h>
#include <tqframe.h>
#include <tqlayout.h>
#include <tqlabel.h>
#include <tqtooltip.h>
#include <tqwhatsthis.h>
#include <tqimage.h>
#include <tqpixmap.h>

#include <kiconloader.h>
#include <tdelocale.h>
#include <tdeaboutdata.h>
#include <kdialogbase.h>

#include <kuniqueapplication.h>
#include "lmsensors.h"
#include "sensorslist.h"
#include "generalcfg.h"
#include "systemcfg.h"
#include "lmsensorscfg.h"
#include "aboutcfgdesign.h"

#define Icon(x) TDEGlobal::instance()->iconLoader()->loadIcon( x, TDEIcon::NoGroup, TDEIcon::SizeMedium )

KSensorsCfg::KSensorsCfg(LMSensors *lsensors, const char *name)
: KDialogBase(IconList, name, Help|Apply|Close, Close )
{
   sensors= lsensors;

   //resize( 558, 370 );
   setSizePolicy(TQSizePolicy(TQSizePolicy::Minimum, TQSizePolicy::Minimum));
   setCaption( i18n("KSensors Configuration") );

   TQFrame *page;
   TQVBoxLayout *lay;
   
   page = addPage( i18n("Global settings"), i18n("Global settings"), Icon("earth.png") );
   m_generalcfg = new GeneralCfg(sensors, page);
   lay = new TQVBoxLayout( page );
   lay->addWidget(m_generalcfg);
   connect(this, TQ_SIGNAL(applyClicked()), m_generalcfg, TQ_SLOT(slotApplyChanges()) );  

   TQObjectList *list= sensors->getSensorsChips();
   if(list) {
     for(SensorsList *chip= (SensorsList *)list->first(); chip!=0; chip= (SensorsList *)list->next())
     {
       if(chip->getClass()==Sensor::lmSensor)
       {
	       page = addPage( chip->getDescription()+TQString(i18n(" sensors")), chip->getDescription()+TQString(i18n(" sensors")), Icon("motherboard.png") );
	       cfgWidget = new LMSensorsCfg(chip, page);
	       lay = new TQVBoxLayout( page );
	       lay->addWidget(cfgWidget);
	       connect(this, TQ_SIGNAL(applyClicked()), cfgWidget, TQ_SLOT(slotApplyChanges()) );
       }
       else
       {
	       page = addPage( chip->getDescription(), chip->getDescription(), Icon("harddisk.png") );
	       cfgWidget = new LMSensorsCfg(chip, page);
	       lay = new TQVBoxLayout( page );
	       lay->addWidget(cfgWidget);
	       connect(this, TQ_SIGNAL(applyClicked()), cfgWidget, TQ_SLOT(slotApplyChanges()) );
       }
     }
   }

   page = addPage( i18n( "System Information" ), i18n( "System Information" ), Icon("computers.png") );
   m_systemcfg = new SystemCfg(sensors, page);
   lay = new TQVBoxLayout( page );
   lay->addWidget(m_systemcfg);
   connect(this, TQ_SIGNAL(applyClicked()), m_systemcfg, TQ_SLOT(slotApplyChanges()) );

   adjustSize();
}

KSensorsCfg::~KSensorsCfg()
{
}

#include "ksensorscfg.moc"
