/***************************************************************************
*   Copyright (C) 2003-2004 by                                            *
*   Unai Garro (ugarro@users.sourceforge.net)                             *
*   Cyril Bosselut (bosselut@b1project.com)                               *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef CREATEUNITDIALOG_H
#define CREATEUNITDIALOG_H

#include <kdialogbase.h>
#include <tqpushbutton.h>
#include <tqgroupbox.h>
#include <tqlayout.h>
#include <tqvbox.h>

#include "datablocks/unit.h"

class KComboBox;
class KLineEdit;

/**
@author Unai Garro
*/
class CreateUnitDialog : public KDialogBase
{
TQ_OBJECT

public:
	CreateUnitDialog( TQWidget *parent, const TQString &name = TQString::null, const TQString &plural = TQString::null, const TQString &name_abbrev = TQString::null, const TQString &plural_abbrev = TQString::null, bool newUnit = true );
	~CreateUnitDialog();
	Unit newUnit( void );

protected slots:
	void nameAbbrevTextChanged(const TQString &);

private:
	//Widgets
	TQGroupBox *box;
	KLineEdit *nameEdit;
	KLineEdit *pluralEdit;
	KLineEdit *nameAbbrevEdit;
	KLineEdit *pluralAbbrevEdit;
	KComboBox *typeComboBox;
};

#endif
