/***************************************************************************
 *   Copyright (C) 2006 by Ken Werner                                      *
 *   ken.werner@web.de                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include "ibmacpifansrc.h"
#include <tqtextstream.h> 
#include <tqfile.h>
#include <tdelocale.h>

IBMACPIFanSrc::IBMACPIFanSrc(TQWidget* inParent, const TQFile& inSourceFile):
		LabelSource(inParent),
		mSourceFile(inSourceFile.name()),
		mTrigger(this){
	mID = "Fan";
	mName = mID;
	mDescription = i18n("This source is provided by the ACPI driver for IBM ThinkPads.");
}

IBMACPIFanSrc::~IBMACPIFanSrc(){
}

std::list<Source*>IBMACPIFanSrc::createInstances(TQWidget* inParent){
	std::list<Source*> list;
	TQFile ibmFile( "/proc/acpi/ibm/fan" );
	if(ibmFile.open(IO_ReadOnly))
		list.push_back(new IBMACPIFanSrc(inParent, ibmFile));
	return list;
}

TQString IBMACPIFanSrc::fetchValue(){
	TQString s = "n/a";
	if(mSourceFile.open(IO_ReadOnly)){
		while( mSourceFile.readLine( s, 64 ) != -1 )
			if(s.startsWith("speed:"))
				break;
		s = s.section( ':', 1, 1 ).stripWhiteSpace() + " rpm";
		mSourceFile.close();
	}
	return s;
}
#include "ibmacpifansrc.moc"
