/***************************************************************************************
    begin                : Sat Apr 26 2003
    copyright            : (C) 2003 by Jeroen Wijnhout (wijnhout@science.uva.nl)
                               2007 by Michel Ludwig (michel.ludwig@kdemail.net)
 ***************************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TEMPLATES_H
#define TEMPLATES_H


/**
  *@author Jeroen Wijnhout
  */

#include <kstandarddirs.h>
#include <kiconview.h>
#include <tdelocale.h>
#include <kprocess.h>
#include <kurl.h>

#include <tqobject.h>
#include <tqvaluelist.h>

#include "kileconstants.h"

#define DEFAULT_EMPTY_ICON "type_Empty"

class KileInfo;

namespace KileTemplate {

struct Info {
	public:
		Info();

		TQString name;
		TQString path;
		TQString icon;
		KileDocument::Type type;
		
		bool operator==(const Info ti) const;
};

typedef TQValueList<Info> TemplateList;
typedef TQValueListIterator<Info> TemplateListIterator;
typedef TQValueListConstIterator<Info> TemplateListConstIterator;

class Manager : public TQObject {
	TQ_OBJECT
  
	
	public:
		Manager(KileInfo *info, TQObject* parent = NULL, const char* name = NULL);
		virtual ~Manager();

		void scanForTemplates();

		/**
		* Get all the templates.
		**/
		TemplateList getAllTemplates() const;

		/**
		* Get all the templates of a certain type.
		*
		* @param type The type of the templates that should be returned. You can pass "KileDocument::Undefined" to
		*             retrieve every template.
		**/
		TemplateList getTemplates(KileDocument::Type type) const;

		/**
		 * Checks whether a template with a given name and type exists.
		 *
		 * @return true iff a template with the given name and type could be found
		 **/
		bool searchForTemplate(const TQString& name, KileDocument::Type& type) const;

		//add a template in $HOME/kile/templates/
		bool add(const KURL& templateSourceURL, const TQString& name, const KURL& icon);
		
		//remove a template from $HOME/kile/templates/
		bool remove(KileTemplate::Info ti);

		//replaces a template
		bool replace(const KileTemplate::Info& toBeReplaced, const KURL& newTemplateSourceURL, const TQString& newName, const KURL& newIcon);

	protected:
		KileInfo* m_kileInfo;

	private:
		bool copyAppData(const KURL& src, const TQString& subdir, const TQString& fileName);
		bool removeAppData(const TQString &file);

		/**
		 * Adds a new template. This method differs from the other add method in that it does not try to determine
		 * the type of the template from the passed source URL.
		 **/
		bool add(const KURL& templateSourceURL, KileDocument::Type type, const TQString& name, const KURL& icon);


	private:
		TemplateList m_TemplateList;
};

}

const TQString DEFAULT_EMPTY_CAPTION = i18n("Empty Document");
const TQString DEFAULT_EMPTY_LATEX_CAPTION = i18n("Empty LaTeX Document");
const TQString DEFAULT_EMPTY_BIBTEX_CAPTION = i18n("Empty BibTeX Document");

class TemplateItem : public TQIconViewItem
{
public:
	TemplateItem( TQIconView * parent, const KileTemplate::Info & info);
	~TemplateItem() {}

	int compare( TQIconViewItem *i ) const;
	
	TQString name() { return m_info.name; }
	TQString path() { return m_info.path; }
	TQString icon() { return m_info.icon; }
	KileDocument::Type type() { return m_info.type; }

private:
	KileTemplate::Info m_info;
};

class TemplateIconView : public TDEIconView {
	TQ_OBJECT
  
	
	public:
		TemplateIconView(TQWidget *parent=0, const char *name=0, WFlags f=0);
		virtual ~TemplateIconView();

		void setTemplateManager(KileTemplate::Manager *templateManager);

		void fillWithTemplates(KileDocument::Type type);

	signals:
		void classFileSearchFinished();

	protected:
		KileTemplate::Manager *m_templateManager;
		TQString m_output;
		TQString m_selicon;
		TDEProcess *m_proc;

		void addTemplateIcons(KileDocument::Type type);
		void searchLaTeXClassFiles();

	protected slots:
		void slotProcessOutput(TDEProcess*,char* buf,int len);
		void slotProcessExited (TDEProcess *proc);
};

#endif
