/***************************************************************************
 *   Copyright (C) 2004-2007 by Georgy Yunaev, gyunaev@ulduzsoft.com       *
 *   Please do not use email address above for bug reports; see            *
 *   the README file                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef KCHMSEARCHWINDOW_H
#define KCHMSEARCHWINDOW_H

#include "tde-tqt.h"

#include "kchmsettings.h"
#include "forwarddeclarations.h"


/**
@author Georgy Yunaev
*/
class KCHMSearchEngine;


class KCHMClickableLabel : public TQLabel
{
	TQ_OBJECT
  
	public:
		KCHMClickableLabel( const TQString& label, TQWidget * parent )
	: TQLabel( label, parent ) {};
		
		virtual ~KCHMClickableLabel() {};
				
	signals:
		void	clicked();
						
	protected:
		virtual void mousePressEvent ( TQMouseEvent * ) 	{ emit clicked(); }
};


class KCHMSearchWindow : public TQWidget
{
	TQ_OBJECT
  
	public:
		KCHMSearchWindow ( TQWidget * parent = 0, const char * name = 0, WFlags f = 0 );
	
		void	invalidate();
		void	restoreSettings (const KCHMSettings::search_saved_settings_t& settings);
		void	saveSettings (KCHMSettings::search_saved_settings_t& settings);
		void	execSearchQueryInGui( const TQString& query );
		bool	searchQuery( const TQString& query, TQStringList * results );
		
	public slots:
		void	slotContextMenuRequested ( TQListViewItem *item, const TQPoint &point, int column );
		
	private slots:
		void	onHelpClicked();
		void 	onReturnPressed ();
		void	onDoubleClicked ( TQListViewItem *, const TQPoint &, int);
	
	private:
		bool	initSearchEngine();
		
	private:
		TQComboBox 		*	m_searchQuery;
		KQListView		*	m_searchList;
		KTQPopupMenu		* 	m_contextMenu;
		
		KCHMSearchEngine*	m_searchEngine;
};

#endif
