/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2004-12-21
 * Description : abstract camera interface class
 * 
 * Copyright (C) 2004-2005 by Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Copyright (C) 2006-2009 by Gilles Caulier <caulier dot gilles at gmail dot com> 
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */

#ifndef DKCAMERA_H
#define DKCAMERA_H

// TQt includes.

#include <tqstring.h>

// Local includes.

#include "gpiteminfo.h"

class TQStringList;
class TQImage;

namespace Digikam
{

class DKCamera
{
public:

    DKCamera(const TQString& title, const TQString& model, const TQString& port, const TQString& path);
    virtual ~DKCamera();

    virtual bool doConnect() = 0;
    virtual void cancel() = 0;

    virtual void getAllFolders(const TQString& folder, TQStringList& subFolderList) = 0;

    /// If getImageDimensions is false, the camera shall set width and height to -1
    /// if the values are not immediately available
    virtual bool getItemsInfoList(const TQString& folder, GPItemInfoList& infoList, bool getImageDimensions = true) = 0;

    virtual bool getThumbnail(const TQString& folder, const TQString& itemName, TQImage& thumbnail) = 0;
    virtual bool getExif(const TQString& folder, const TQString& itemName, char **edata, int& esize) = 0;

    virtual bool downloadItem(const TQString& folder, const TQString& itemName, const TQString& saveFile) = 0;
    virtual bool deleteItem(const TQString& folder, const TQString& itemName) = 0;
    virtual bool uploadItem(const TQString& folder, const TQString& itemName, const TQString& localFile,
                            GPItemInfo& itemInfo, bool getImageDimensions=true) = 0;
    virtual bool cameraSummary(TQString& summary) = 0;
    virtual bool cameraManual(TQString& manual) = 0;
    virtual bool cameraAbout(TQString& about) = 0;

    virtual bool setLockItem(const TQString& folder, const TQString& itemName, bool lock) = 0;

    TQString title() const;
    TQString model() const;
    TQString port()  const;
    TQString path()  const;

protected:

    TQString mimeType(const TQString& fileext) const;

protected:

    TQString m_imageFilter;
    TQString m_movieFilter;
    TQString m_audioFilter;
    TQString m_rawFilter;

private:

    TQString m_title;
    TQString m_model;
    TQString m_port;
    TQString m_path;
};

}  // namespace Digikam

#endif /* DKCAMERA_H */
