// Author:    Max Howell <max.howell@methylblue.com>, (C) 2005
// Copyright: See COPYING file that comes with this distribution

#include "../codeine.h"
#include "../debug.h"
#include <tdeaboutdata.h>
#include <tdeparts/genericfactory.h>
#include "part.h"
#include <tqtimer.h>
#include "toolbar.h"
#include "videoWindow.h"

#include <tdeaction.h>
#include <tqslider.h>

namespace Codeine
{
   typedef KParts::GenericFactory<Codeine::Part> Factory;
}


K_EXPORT_COMPONENT_FACTORY( libcodeine, Codeine::Factory )


namespace Codeine
{
   Part::Part( TQWidget *parentWidget, const char *widgetName, TQObject *parent, const char *name, const TQStringList& )
         : ReadOnlyPart( parent, name )
         , m_statusBarExtension( new KParts::StatusBarExtension( this ) )
   {
      setInstance( Factory::instance() );
      setWidget( new VideoWindow( parentWidget, widgetName ) );

      if( !videoWindow()->init() )
         //FIXME this will terminate the host, eg Konqueror
         Debug::fatal() << "Couldn't init xine!\n";

      TDEAction *play = new TDEToggleAction( i18n("Play"), "media-playback-start", TQt::Key_Space, videoWindow(), SLOT(togglePlay()), actionCollection(), "play" );
      TDEAction *mute = new TDEToggleAction( i18n("Mute"), "player_mute", TQt::Key_M, videoWindow(), SLOT(toggleMute()), actionCollection(), "mute" );
      TDEToolBar *toolBar = new MouseOverToolBar( widget() );
      play->plug( toolBar );
      mute->plug( toolBar );
      m_slider = new TQSlider( TQt::Horizontal, toolBar, "slider" );
      m_slider->setMaxValue( 65535 );
      toolBar->setStretchableWidget( m_slider );
      toolBar->addSeparator(); //FIXME ugly

      TQObject *o = (TQObject*)statusBar();
      connect( videoWindow(), SIGNAL(statusMessage( const TQString& )), o, SLOT(message( const TQString& )) );
      connect( videoWindow(), SIGNAL(titleChanged( const TQString& )), o, SLOT(message( const TQString& )) ); //FIXME
   }

   bool
   Part::openURL( const KURL &url )
   {
      //FIXME nasty, we'd rather not do this way
      killTimers();
      startTimer( 100 );

      return videoWindow()->play( m_url = url );
   }

   bool
   Part::closeURL()
   {
      m_url = KURL();
      videoWindow()->eject();
      return true;
   }

   TDEAboutData*
   Part::createAboutData()
   {
      // generic factory expects this on the heap
      return new TDEAboutData( APP_NAME, PRETTY_NAME, APP_VERSION );
   }

   void
   Part::timerEvent( TQTimerEvent* )
   {
      m_slider->setValue( videoWindow()->position() );
   }
}
